/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;

public interface TextOutput {
    public Path getFile();

    public boolean isGzipped();

    public boolean isAppend();

    public Charset getEncoding();

    public OutputStream getStdOutStream();

    public Charset getStdOutEncoding();

    default public Writer newCharWriter() throws IOException {
        if (this.hasFile()) {
            OutputStream stream = Files.newOutputStream(this.getFile(), StandardOpenOption.CREATE, this.isAppend() ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
            return new OutputStreamWriter(this.isGzippedFile() ? new GZIPOutputStream(stream) : stream, this.getEncoding());
        }
        return new OutputStreamWriter((OutputStream)new UncloseableOutputStream(this.getStdOutStream()), this.getStdOutEncoding());
    }

    default public void writeString(String text) throws IOException {
        try (Writer writer = this.newCharWriter();){
            writer.write(text);
        }
    }

    default public boolean hasFile() {
        return this.getFile() != null;
    }

    default public boolean isGzippedFile() {
        return this.hasFile() && (this.isGzipped() || this.getFile().toString().toLowerCase(Locale.ROOT).endsWith(".gz"));
    }

    default public boolean isAppending() throws IOException {
        return this.hasFile() && this.isAppend() && Files.exists(this.getFile(), new LinkOption[0]) && Files.size(this.getFile()) > 0L;
    }

    public static final class UncloseableOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        @Override
        public void close() throws IOException {
            this.flush();
            super.close();
        }

        @Generated
        public UncloseableOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        @Generated
        public void write(int arg0) throws IOException {
            this.delegate.write(arg0);
        }

        @Override
        @Generated
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        @Generated
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        @Generated
        public void flush() throws IOException {
            this.delegate.flush();
        }
    }
}

