/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import lombok.Generated;
import nbbrd.console.picocli.yaml.YamlOutputOptions;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import picocli.CommandLine;

@CommandLine.Command(name="print-context", description={"Print system and environment context."}, helpCommand=true)
public class PrintContext
implements Callable<Void> {
    @CommandLine.ArgGroup(validate=false, heading="%nCSV options:%n")
    private YamlOutputOptions output = new YamlOutputOptions();
    @CommandLine.Option(names={"-t", "--type"}, paramLabel="<type>", description={"Context type (${COMPLETION-CANDIDATES})."}, defaultValue="SYS")
    private ContextType type;

    @Override
    public Void call() throws Exception {
        this.output.dump(this.getYaml(), this.getType().get());
        return null;
    }

    private Yaml getYaml() {
        DumperOptions opts = new DumperOptions();
        opts.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(opts);
    }

    @Generated
    public ContextType getType() {
        return this.type;
    }

    @Generated
    public void setType(ContextType type) {
        this.type = type;
    }

    public static enum ContextType implements Supplier<Object>
    {
        SYS{

            @Override
            public Object get() {
                return new TreeMap<Object, Object>(System.getProperties());
            }
        }
        ,
        ENV{

            @Override
            public Object get() {
                return new TreeMap<String, String>(System.getenv());
            }
        };

    }
}

