/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import internal.console.picocli.RecursiveFiles;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOPredicate;

public interface MultiFileInput {
    public List<Path> getFiles();

    public boolean isRecursive();

    public boolean isSkipErrors();

    default public boolean isSingleFile() {
        return this.getFiles().size() == 1 && Files.isRegularFile(this.getFiles().get(0), new LinkOption[0]);
    }

    default public Path getSingleFile() {
        return this.getFiles().get(0);
    }

    default public List<Path> getAllFiles(IOPredicate<? super Path> filter) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path item : this.getFiles()) {
            try {
                Stream<Path> files = RecursiveFiles.walk(item, this.isRecursive(), filter);
                try {
                    files.forEach(result::add);
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }
        return result;
    }

    default public <T> Function<Path, Optional<T>> asFunction(IOFunction<Path, T> delegate, BiConsumer<Exception, Path> report) {
        return this.isSkipErrors() ? RecursiveFiles.applyOrReport(delegate, report).andThen(Optional::ofNullable) : delegate.andThen(Optional::ofNullable).asUnchecked();
    }

    default public Consumer<Path> asConsumer(IOConsumer<Path> delegate, BiConsumer<Exception, Path> report) {
        return this.isSkipErrors() ? RecursiveFiles.acceptOrReport(delegate, report) : delegate.asUnchecked();
    }
}

