/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.console.picocli;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import nbbrd.io.sys.SystemProperties;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JarPathHelper {
    @lombok.NonNull
    private final SystemProperties system;

    public @Nullable Path getJarPath(@NonNull Class<?> anchor, @NonNull Predicate<? super Path> filter) {
        Objects.requireNonNull(anchor);
        Objects.requireNonNull(filter);
        List<Path> classPath = this.system.getJavaClassPath();
        switch (classPath.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return classPath.get(0).toAbsolutePath();
            }
        }
        Path result = JarPathHelper.getFromProtectionDomain(anchor);
        if (JarPathHelper.isValidJarPath(result)) {
            return result;
        }
        result = JarPathHelper.getFromSystemClassLoader();
        if (JarPathHelper.isValidJarPath(result)) {
            return result;
        }
        return classPath.stream().filter(filter).findFirst().orElse(null);
    }

    static Path getFromProtectionDomain(Class<?> anchor) {
        try {
            return JarPathHelper.urlToAbsolutePath(anchor.getProtectionDomain().getCodeSource().getLocation());
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    static Path getFromSystemClassLoader() {
        return JarPathHelper.urlToAbsolutePath(ClassLoader.getSystemClassLoader().getResource("."));
    }

    static Path urlToAbsolutePath(URL url) {
        try {
            return url != null ? Paths.get(url.toURI()).toAbsolutePath() : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    static boolean isValidJarPath(Path path) {
        return path != null && path.toString().toLowerCase(Locale.ROOT).endsWith(".jar");
    }

    @Generated
    private JarPathHelper(@lombok.NonNull SystemProperties system) {
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        this.system = system;
    }

    @Generated
    public static @NonNull JarPathHelper of(@lombok.NonNull SystemProperties system) {
        return new JarPathHelper(system);
    }
}

