/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LegacyFiles {
    public static @NonNull InputStream newInputStream(@NonNull File source) throws IOException {
        return new BufferedFileInputStream(source);
    }

    public static @NonNull OutputStream newOutputStream(@NonNull File target) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(target));
    }

    public static void checkSource(@NonNull File source) throws FileSystemException {
        Objects.requireNonNull(source, "source");
        LegacyFiles.checkExist(source);
        LegacyFiles.checkIsFile(source);
    }

    public static void checkTarget(@NonNull File target) throws FileSystemException {
        Objects.requireNonNull(target, "target");
        if (target.exists()) {
            LegacyFiles.checkIsFile(target);
        }
    }

    public static void checkExist(@NonNull File source) throws FileSystemException {
        if (!source.exists()) {
            throw new NoSuchFileException(source.getPath());
        }
    }

    public static void checkIsFile(@NonNull File source) throws FileSystemException {
        if (!source.isFile()) {
            throw new AccessDeniedException(source.getPath());
        }
    }

    public static String toSystemId(File file) {
        return file.toURI().toASCIIString();
    }

    public static File fromSystemId(String systemId) {
        try {
            return new File(URI.create(systemId));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T extends Closeable> T checkResource(T resource, String message) throws IOException {
        if (resource == null) {
            throw new IOException(message);
        }
        return resource;
    }

    @Generated
    private LegacyFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class BufferedFileInputStream
    extends BufferedInputStream {
        private final File file;

        public BufferedFileInputStream(File source) throws FileNotFoundException {
            super(new FileInputStream(source));
            this.file = source;
        }

        public File getFile() {
            return this.file;
        }
    }
}

