/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;

public final class InternalFormatter {
    public static CharSequence formatTemporalAccessor(DateTimeFormatter formatter, TemporalAccessor value) {
        if (value != null) {
            try {
                return formatter.format(value);
            }
            catch (DateTimeException ex) {
                InternalFormatter.doNothing(ex);
            }
        }
        return null;
    }

    public static CharSequence formatDate(DateFormat format, Date value) {
        return value != null ? format.format(value) : null;
    }

    public static CharSequence formatNumber(NumberFormat format, Number value) {
        return value != null ? format.format(value) : null;
    }

    public static CharSequence formatDoubleArray(double[] value) {
        return value != null ? Arrays.toString(value) : null;
    }

    public static CharSequence formatStringArray(String[] value) {
        return value != null ? Arrays.toString(value) : null;
    }

    public static CharSequence formatStringList(Function<Stream<CharSequence>, String> joiner, List<String> value) {
        if (value != null) {
            try {
                return joiner.apply(value.stream().map(CharSequence.class::cast));
            }
            catch (Exception ex) {
                InternalFormatter.doNothing(ex);
            }
        }
        return null;
    }

    public static <T> CharSequence formatConstant(CharSequence constant, T value) {
        return constant;
    }

    public static <T> CharSequence formatNull(T value) {
        return null;
    }

    public static CharSequence formatFile(File value) {
        return value != null ? value.getPath() : null;
    }

    public static CharSequence formatInteger(Integer value) {
        return value != null ? value.toString() : null;
    }

    public static CharSequence formatLong(Long value) {
        return value != null ? value.toString() : null;
    }

    public static CharSequence formatDouble(Double value) {
        return value != null ? value.toString() : null;
    }

    public static CharSequence formatBoolean(Boolean value) {
        return value != null ? value.toString() : null;
    }

    public static CharSequence formatCharacter(Character value) {
        return value != null ? value.toString() : null;
    }

    public static CharSequence formatCharset(Charset value) {
        return value != null ? value.name() : null;
    }

    public static CharSequence formatEnum(Enum<?> value) {
        return value != null ? value.name() : null;
    }

    public static CharSequence formatString(String value) {
        return value;
    }

    public static CharSequence formatObjectToString(Object value) {
        return value != null ? value.toString() : null;
    }

    public static CharSequence formatURL(URL value) {
        return value != null ? value.toString() : null;
    }

    public static <T> CharSequence formatFailsafe(Function<? super T, ? extends CharSequence> formatter, Consumer<? super Throwable> onError, T input) {
        if (input != null) {
            try {
                return formatter.apply(input);
            }
            catch (Throwable ex) {
                onError.accept(ex);
            }
        }
        return null;
    }

    public static void doNothing(Throwable ex) {
    }

    @Generated
    private InternalFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

