/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SpecialProperties {
    public static final String DEBUG_OPTION = "--debug";
    public static final String BATCH_OPTION = "--batch";
    public static final String NO_CONFIG_OPTION = "--no-config";
    private final boolean debugRequired;
    private final boolean batchRequired;
    private final boolean noConfig;

    @lombok.NonNull
    public static SpecialProperties parse(@lombok.NonNull String[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        List<String> tmp = Arrays.asList(args);
        return new SpecialProperties(tmp.contains(DEBUG_OPTION), tmp.contains(BATCH_OPTION), tmp.contains(NO_CONFIG_OPTION));
    }

    public void apply(Properties properties) {
        if (this.debugRequired) {
            // empty if block
        }
        if (this.batchRequired) {
            SpecialProperties.disableAnsi(properties);
        }
    }

    public static void disableAnsi(Properties properties) {
        properties.setProperty("picocli.ansi", "false");
        properties.setProperty("org.fusesource.jansi.Ansi.disable", "true");
    }

    @Generated
    public boolean isDebugRequired() {
        return this.debugRequired;
    }

    @Generated
    public boolean isBatchRequired() {
        return this.batchRequired;
    }

    @Generated
    public boolean isNoConfig() {
        return this.noConfig;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecialProperties)) {
            return false;
        }
        SpecialProperties other = (SpecialProperties)o;
        if (this.isDebugRequired() != other.isDebugRequired()) {
            return false;
        }
        if (this.isBatchRequired() != other.isBatchRequired()) {
            return false;
        }
        return this.isNoConfig() == other.isNoConfig();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebugRequired() ? 79 : 97);
        result = result * 59 + (this.isBatchRequired() ? 79 : 97);
        result = result * 59 + (this.isNoConfig() ? 79 : 97);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SpecialProperties(debugRequired=" + this.isDebugRequired() + ", batchRequired=" + this.isBatchRequired() + ", noConfig=" + this.isNoConfig() + ")";
    }

    @Generated
    private SpecialProperties(boolean debugRequired, boolean batchRequired, boolean noConfig) {
        this.debugRequired = debugRequired;
        this.batchRequired = batchRequired;
        this.noConfig = noConfig;
    }
}

