/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.util.ast.Document;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import nbbrd.console.picocli.text.TextOutput;
import nbbrd.console.properties.ConsoleProperties;
import picocli.CommandLine;

public class MarkdownOutputOptions
implements TextOutput {
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="<file>", description={"Output to a file instead of stdout."})
    private Path file;

    @Override
    public boolean isGzipped() {
        return false;
    }

    @Override
    public boolean isAppend() {
        return false;
    }

    @Override
    public Charset getEncoding() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public OutputStream getStdOutStream() {
        return System.out;
    }

    @Override
    public Charset getStdOutEncoding() {
        return ConsoleProperties.ofServiceLoader().getStdOutEncoding().orElse(StandardCharsets.UTF_8);
    }

    public void write(Document document) throws IOException {
        Formatter formatter = Formatter.builder().build();
        try (Writer writer = this.newCharWriter();){
            formatter.render(document, writer);
        }
    }

    @Override
    @Generated
    public Path getFile() {
        return this.file;
    }

    @Generated
    public void setFile(Path file) {
        this.file = file;
    }
}

