/*
 * Decompiled with CFR 0.152.
 */
package internal.console.properties.x;

import internal.console.properties.x.Utils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.properties.ConsoleProperties;
import nbbrd.io.sys.OS;

public final class ChcpConsoleProvider
implements ConsoleProperties.Spi {
    @NonNull
    private final BiConsumer<IOException, String[]> onError;
    private static final Pattern CHCP_PATTERN = Pattern.compile("\\d+", 8);

    public ChcpConsoleProvider() {
        this(Utils::logCommandException);
    }

    @Override
    public boolean isAvailable() {
        return OS.NAME.equals((Object)OS.Name.WINDOWS) && !Utils.isMingwXterm(System::getenv);
    }

    @Override
    public int getRank() {
        return 20;
    }

    @Override
    public Charset getStdInEncodingOrNull() {
        return this.getChcpEncodingOrNull();
    }

    @Override
    public Charset getStdOutEncodingOrNull() {
        return this.getChcpEncodingOrNull();
    }

    @Override
    public int getColumns() {
        return -1;
    }

    @Override
    public int getRows() {
        return -1;
    }

    private Charset getChcpEncodingOrNull() {
        return Utils.execToString(this.onError, "cmd", "/C", "chcp").map(ChcpConsoleProvider::parseChcp).orElse(null);
    }

    static Charset parseChcp(String chcp) {
        Matcher m = CHCP_PATTERN.matcher(chcp);
        if (m.find()) {
            return Charset.forName("cp" + m.group());
        }
        throw new IllegalArgumentException("Invalid chcp result: '" + chcp + "'");
    }

    @Generated
    ChcpConsoleProvider(@NonNull BiConsumer<IOException, String[]> onError) {
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        this.onError = onError;
    }
}

