/*
 * Decompiled with CFR 0.152.
 */
package internal.console.picocli.csv;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.console.picocli.csv.CsvNewLine;
import nbbrd.design.VisibleForTesting;
import nbbrd.io.sys.OS;
import nbbrd.io.win.RegWrapper;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ExcelCsv {
    public static ExcelCsv INSTANCE = new ExcelCsv(Spi.get());
    @NonNull
    private final Spi provider;

    public @org.checkerframework.checker.nullness.qual.NonNull CsvNewLine getSeparator() {
        return CsvNewLine.WINDOWS;
    }

    public char getDelimiter() {
        Character result = this.provider.getDelimiterOrNull(this.getDecimalSeparator());
        return result != null ? (char)result.charValue() : (char)',';
    }

    public char getQuote() {
        return '\"';
    }

    public @org.checkerframework.checker.nullness.qual.NonNull Charset getEncoding() {
        return Charset.defaultCharset();
    }

    public @org.checkerframework.checker.nullness.qual.NonNull Locale getLocale() {
        return Locale.getDefault(Locale.Category.FORMAT);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull String getDatePattern() {
        String result = this.provider.getDatePatternOrNull();
        return result != null ? result : this.getLocalizedDateTimePattern(FormatStyle.SHORT, null);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull String getTimePattern() {
        String result = this.provider.getTimePatternOrNull();
        return result != null ? result : this.getLocalizedDateTimePattern(null, FormatStyle.SHORT);
    }

    public @org.checkerframework.checker.nullness.qual.NonNull String getDateTimePattern() {
        return this.getDatePattern() + " " + this.getTimePattern();
    }

    private char getDecimalSeparator() {
        return new DecimalFormatSymbols(this.getLocale()).getDecimalSeparator();
    }

    private String getLocalizedDateTimePattern(FormatStyle dateStyle, FormatStyle timeStyle) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(dateStyle, timeStyle, IsoChronology.INSTANCE, this.getLocale());
    }

    @Generated
    private ExcelCsv(@NonNull Spi provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.provider = provider;
    }

    @VisibleForTesting
    static enum Spi {
        WIN{

            @Override
            public Character getDelimiterOrNull(char decimalSeparator) {
                if (decimalSeparator == ',') {
                    return Character.valueOf(';');
                }
                String result = this.get("sList");
                return result != null && result.length() == 1 ? Character.valueOf(result.charAt(0)) : null;
            }

            @Override
            public String getDatePatternOrNull() {
                return this.get("sShortDate");
            }

            @Override
            public String getTimePatternOrNull() {
                return this.get("sShortTime");
            }

            private String get(String key) {
                try {
                    return RegWrapper.query((String)"HKCU\\Control Panel\\International", (boolean)false).values().stream().flatMap(Collection::stream).filter(o -> o.getName().equals(key)).map(RegWrapper.RegValue::getValue).findFirst().orElse(null);
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "While querying", ex);
                    return null;
                }
            }
        }
        ,
        MAC{

            @Override
            public Character getDelimiterOrNull(char decimalSeparator) {
                return Character.valueOf(decimalSeparator == ',' ? (char)';' : ',');
            }

            @Override
            public String getDatePatternOrNull() {
                return null;
            }

            @Override
            public String getTimePatternOrNull() {
                return null;
            }
        }
        ,
        UNKNOWN{

            @Override
            public Character getDelimiterOrNull(char decimalSeparator) {
                return null;
            }

            @Override
            public String getDatePatternOrNull() {
                return null;
            }

            @Override
            public String getTimePatternOrNull() {
                return null;
            }
        };

        @Generated
        private static final Logger log;
        private static final char COMMA = ',';
        private static final char SEMICOLON = ';';

        public abstract @Nullable Character getDelimiterOrNull(char var1);

        public abstract @Nullable String getDatePatternOrNull();

        public abstract @Nullable String getTimePatternOrNull();

        public static @org.checkerframework.checker.nullness.qual.NonNull Spi get() {
            switch (OS.NAME) {
                case WINDOWS: {
                    return WIN;
                }
                case MACOS: {
                    return MAC;
                }
            }
            return UNKNOWN;
        }

        static {
            log = Logger.getLogger(Spi.class.getName());
        }
    }
}

