/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.collection.iteration.ArrayIterable;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.IRichSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.mappers.ChangeCase;
import com.vladsch.flexmark.util.sequence.mappers.CharMapper;
import com.vladsch.flexmark.util.sequence.mappers.SpaceMapper;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IRichSequenceBase<T extends IRichSequence<T>>
implements IRichSequence<T> {
    private int hash;

    public IRichSequenceBase(int hash) {
        this.hash = hash;
    }

    @Override
    @Contract(pure=true, value="null -> false")
    public final boolean equals(Object o) {
        return SequenceUtils.equals(this, o);
    }

    @Override
    @Contract(pure=true)
    public final int hashCode() {
        int h = this.hash;
        if (h == 0 && this.length() > 0) {
            this.hash = h = SequenceUtils.hashCode(this);
        }
        return h;
    }

    @Override
    @Contract(pure=true, value="null -> false")
    public final boolean equalsIgnoreCase(@Nullable Object other) {
        return this == other || other instanceof CharSequence && ((CharSequence)other).length() == this.length() && this.matchChars((CharSequence)other, 0, true);
    }

    @Override
    @Contract(pure=true, value="null, _ ->false")
    public final boolean equals(@Nullable Object other, boolean ignoreCase) {
        return this == other || other instanceof CharSequence && ((CharSequence)other).length() == this.length() && this.matchChars((CharSequence)other, 0, ignoreCase);
    }

    @Override
    public int compareTo(@NotNull CharSequence o) {
        return SequenceUtils.compare(this, o);
    }

    @Override
    @NotNull
    public final T sequenceOf(@Nullable CharSequence charSequence) {
        return charSequence == null ? this.nullSequence() : this.sequenceOf(charSequence, 0, charSequence.length());
    }

    @Override
    @NotNull
    public final T sequenceOf(@Nullable CharSequence charSequence, int startIndex) {
        return charSequence == null ? this.nullSequence() : this.sequenceOf(charSequence, startIndex, charSequence.length());
    }

    @Override
    @NotNull
    public final T subSequence(int startIndex) {
        return (T)this.subSequence(startIndex, this.length());
    }

    @Override
    @NotNull
    public final T subSequence(@NotNull Range range) {
        return (T)(range.isNull() ? this : this.subSequence(range.getStart(), range.getEnd()));
    }

    @Override
    @NotNull
    public final T subSequenceBefore(@NotNull Range range) {
        return (T)(range.isNull() ? this.nullSequence() : this.subSequence(0, range.getStart()));
    }

    @Override
    @NotNull
    public final T subSequenceAfter(@NotNull Range range) {
        return range.isNull() ? this.nullSequence() : this.subSequence(range.getEnd());
    }

    public final Pair<T, T> subSequenceBeforeAfter(Range range) {
        return Pair.of(this.subSequenceBefore(range), this.subSequenceAfter(range));
    }

    @Override
    @NotNull
    public final T endSequence(int startIndex, int endIndex) {
        int length = this.length();
        int useStart = length - startIndex;
        int useEnd = length - endIndex;
        useEnd = Utils.rangeLimit(useEnd, 0, length);
        useStart = Utils.rangeLimit(useStart, 0, useEnd);
        return (T)this.subSequence(useStart, useEnd);
    }

    @Override
    @NotNull
    public final T endSequence(int startIndex) {
        return this.endSequence(startIndex, 0);
    }

    @Override
    public final char endCharAt(int index) {
        int length = this.length();
        if (index < 0 || index >= length) {
            return '\u0000';
        }
        return this.charAt(length - index);
    }

    @Override
    @NotNull
    public final T midSequence(int startIndex, int endIndex) {
        int length = this.length();
        int useStart = startIndex < 0 ? length + startIndex : startIndex;
        int useEnd = endIndex < 0 ? length + endIndex : endIndex;
        useEnd = Utils.rangeLimit(useEnd, 0, length);
        useStart = Utils.rangeLimit(useStart, 0, useEnd);
        return (T)this.subSequence(useStart, useEnd);
    }

    @Override
    @NotNull
    public final T midSequence(int startIndex) {
        return this.midSequence(startIndex, this.length());
    }

    @Override
    public final char midCharAt(int index) {
        int length = this.length();
        if (index < -length || index >= length) {
            return '\u0000';
        }
        return this.charAt(index < 0 ? length + index : index);
    }

    @Override
    public final char lastChar() {
        return this.isEmpty() ? (char)'\u0000' : this.charAt(this.length() - 1);
    }

    @Override
    public final char firstChar() {
        return this.isEmpty() ? (char)'\u0000' : this.charAt(0);
    }

    public final void validateIndex(int index) {
        SequenceUtils.validateIndex(index, this.length());
    }

    public final void validateIndexInclusiveEnd(int index) {
        SequenceUtils.validateIndexInclusiveEnd(index, this.length());
    }

    public final void validateStartEnd(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
    }

    @Override
    public char safeCharAt(int index) {
        return index < 0 || index >= this.length() ? (char)'\u0000' : this.charAt(index);
    }

    @Override
    @NotNull
    public T safeSubSequence(int startIndex, int endIndex) {
        int length = this.length();
        startIndex = Math.max(0, Math.min(length, startIndex));
        endIndex = Math.max(startIndex, Math.min(length, endIndex));
        return (T)this.subSequence(startIndex, endIndex);
    }

    @Override
    @NotNull
    public T safeSubSequence(int startIndex) {
        int length = this.length();
        startIndex = Math.max(0, Math.min(length, startIndex));
        return (T)this.subSequence(startIndex, length);
    }

    @Override
    public boolean isCharAt(int index, @NotNull CharPredicate predicate) {
        return predicate.test(this.safeCharAt(index));
    }

    @Override
    @Nullable
    public String toStringOrNull() {
        return this.isNull() ? null : this.toString();
    }

    @Override
    public final int indexOf(@NotNull CharSequence s) {
        return SequenceUtils.indexOf((CharSequence)this, s);
    }

    @Override
    public final int indexOf(@NotNull CharSequence s, int fromIndex) {
        return SequenceUtils.indexOf((CharSequence)this, s, fromIndex);
    }

    @Override
    public final int indexOf(@NotNull CharSequence s, int fromIndex, int endIndex) {
        return SequenceUtils.indexOf((CharSequence)this, s, fromIndex, endIndex);
    }

    @Override
    public final int indexOf(char c) {
        return SequenceUtils.indexOf((CharSequence)this, c);
    }

    @Override
    public final int indexOf(char c, int fromIndex) {
        return SequenceUtils.indexOf((CharSequence)this, c, fromIndex);
    }

    @Override
    public final int indexOfAny(@NotNull CharPredicate s) {
        return SequenceUtils.indexOfAny(this, s);
    }

    @Override
    public final int indexOfAny(@NotNull CharPredicate s, int index) {
        return SequenceUtils.indexOfAny(this, s, index);
    }

    @Override
    public final int indexOfAnyNot(@NotNull CharPredicate s) {
        return SequenceUtils.indexOfAnyNot(this, s);
    }

    @Override
    public final int indexOfAnyNot(@NotNull CharPredicate s, int fromIndex) {
        return SequenceUtils.indexOfAnyNot(this, s, fromIndex);
    }

    @Override
    public final int indexOfAnyNot(@NotNull CharPredicate s, int fromIndex, int endIndex) {
        return SequenceUtils.indexOfAnyNot(this, s, fromIndex, endIndex);
    }

    @Override
    public final int indexOfNot(char c) {
        return SequenceUtils.indexOfNot(this, c);
    }

    @Override
    public final int indexOfNot(char c, int fromIndex) {
        return SequenceUtils.indexOfNot(this, c, fromIndex);
    }

    @Override
    public final int lastIndexOf(char c) {
        return SequenceUtils.lastIndexOf((CharSequence)this, c);
    }

    @Override
    public final int lastIndexOf(char c, int fromIndex) {
        return SequenceUtils.lastIndexOf((CharSequence)this, c, fromIndex);
    }

    @Override
    public final int lastIndexOfNot(char c) {
        return SequenceUtils.lastIndexOfNot(this, c);
    }

    @Override
    public final int lastIndexOfNot(char c, int fromIndex) {
        return SequenceUtils.lastIndexOfNot(this, c, fromIndex);
    }

    @Override
    public final int lastIndexOf(@NotNull CharSequence s) {
        return SequenceUtils.lastIndexOf((CharSequence)this, s);
    }

    @Override
    public final int lastIndexOf(@NotNull CharSequence s, int fromIndex) {
        return SequenceUtils.lastIndexOf((CharSequence)this, s, fromIndex);
    }

    @Override
    public final int lastIndexOfAny(@NotNull CharPredicate s, int fromIndex) {
        return SequenceUtils.lastIndexOfAny(this, s, fromIndex);
    }

    @Override
    public final int lastIndexOfAny(@NotNull CharPredicate s) {
        return SequenceUtils.lastIndexOfAny(this, s);
    }

    @Override
    public final int lastIndexOfAnyNot(@NotNull CharPredicate s) {
        return SequenceUtils.lastIndexOfAnyNot(this, s);
    }

    @Override
    public final int lastIndexOfAnyNot(@NotNull CharPredicate s, int fromIndex) {
        return SequenceUtils.lastIndexOfAnyNot(this, s, fromIndex);
    }

    @Override
    public final int lastIndexOfAnyNot(@NotNull CharPredicate s, int startIndex, int fromIndex) {
        return SequenceUtils.lastIndexOfAnyNot(this, s, startIndex, fromIndex);
    }

    @Override
    public final int indexOf(char c, int fromIndex, int endIndex) {
        return SequenceUtils.indexOf((CharSequence)this, c, fromIndex, endIndex);
    }

    @Override
    public final int indexOfNot(char c, int fromIndex, int endIndex) {
        return SequenceUtils.indexOfNot(this, c, fromIndex, endIndex);
    }

    @Override
    public final int indexOfAny(@NotNull CharPredicate s, int fromIndex, int endIndex) {
        return SequenceUtils.indexOfAny(this, s, fromIndex, endIndex);
    }

    @Override
    public final int lastIndexOf(@NotNull CharSequence s, int startIndex, int fromIndex) {
        return SequenceUtils.lastIndexOf((CharSequence)this, s, startIndex, fromIndex);
    }

    @Override
    public final int lastIndexOf(char c, int startIndex, int fromIndex) {
        return SequenceUtils.lastIndexOf((CharSequence)this, c, startIndex, fromIndex);
    }

    @Override
    public final int lastIndexOfNot(char c, int startIndex, int fromIndex) {
        return SequenceUtils.lastIndexOfNot(this, c, startIndex, fromIndex);
    }

    @Override
    public final int lastIndexOfAny(@NotNull CharPredicate s, int startIndex, int fromIndex) {
        return SequenceUtils.lastIndexOfAny(this, s, startIndex, fromIndex);
    }

    @Override
    public final int countOfSpaceTab() {
        return SequenceUtils.countOfSpaceTab(this);
    }

    @Override
    public final int countOfNotSpaceTab() {
        return SequenceUtils.countOfNotSpaceTab(this);
    }

    @Override
    public final int countOfWhitespace() {
        return SequenceUtils.countOfWhitespace(this);
    }

    @Override
    public final int countOfNotWhitespace() {
        return SequenceUtils.countOfNotWhitespace(this);
    }

    @Override
    public final int countOfAny(@NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countOfAny(this, chars, fromIndex);
    }

    @Override
    public final int countOfAny(@NotNull CharPredicate chars) {
        return SequenceUtils.countOfAny(this, chars);
    }

    @Override
    public final int countOfAnyNot(@NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countOfAnyNot(this, chars, fromIndex);
    }

    @Override
    public final int countOfAnyNot(@NotNull CharPredicate chars) {
        return SequenceUtils.countOfAnyNot(this, chars);
    }

    @Override
    public final int countOfAny(@NotNull CharPredicate s, int fromIndex, int endIndex) {
        return SequenceUtils.countOfAny(this, s, fromIndex, endIndex);
    }

    @Override
    public final int countOfAnyNot(@NotNull CharPredicate chars, int startIndex, int endIndex) {
        return SequenceUtils.countOfAnyNot(this, chars, startIndex, endIndex);
    }

    @Override
    public final int countLeading(@NotNull CharPredicate chars) {
        return SequenceUtils.countLeading(this, chars);
    }

    @Override
    public final int countLeading(@NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countLeading(this, chars, fromIndex);
    }

    @Override
    public final int countLeadingNot(@NotNull CharPredicate chars) {
        return SequenceUtils.countLeadingNot(this, chars);
    }

    @Override
    public final int countLeadingNot(@NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countLeadingNot(this, chars, fromIndex);
    }

    @Override
    public final int countTrailing(@NotNull CharPredicate chars) {
        return SequenceUtils.countTrailing(this, chars);
    }

    @Override
    public final int countTrailing(@NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countTrailing(this, chars, fromIndex);
    }

    @Override
    public final int countTrailingNot(@NotNull CharPredicate chars) {
        return SequenceUtils.countTrailingNot(this, chars);
    }

    @Override
    public final int countTrailingNot(@NotNull CharPredicate chars, int fromIndex) {
        return SequenceUtils.countTrailingNot(this, chars, fromIndex);
    }

    @Override
    public final int countLeadingNot(@NotNull CharPredicate chars, int startIndex, int endIndex) {
        return SequenceUtils.countLeadingNot(this, chars, startIndex, endIndex);
    }

    @Override
    public final int countTrailingNot(@NotNull CharPredicate chars, int startIndex, int endIndex) {
        return SequenceUtils.countTrailingNot(this, chars, startIndex, endIndex);
    }

    @Override
    public final int countLeading(@NotNull CharPredicate chars, int fromIndex, int endIndex) {
        return SequenceUtils.countLeading(this, chars, fromIndex, endIndex);
    }

    @Override
    public final int countLeadingColumns(int startColumn, @NotNull CharPredicate chars) {
        return SequenceUtils.countLeadingColumns(this, startColumn, chars);
    }

    @Override
    public final int countTrailing(@NotNull CharPredicate chars, int startIndex, int fromIndex) {
        return SequenceUtils.countTrailing(this, chars, startIndex, fromIndex);
    }

    @Override
    public final int countLeadingSpace() {
        return SequenceUtils.countLeadingSpace(this);
    }

    @Override
    public final int countLeadingNotSpace() {
        return SequenceUtils.countLeadingNotSpace(this);
    }

    @Override
    public final int countLeadingSpace(int startIndex) {
        return SequenceUtils.countLeadingSpace(this, startIndex);
    }

    @Override
    public final int countLeadingNotSpace(int startIndex) {
        return SequenceUtils.countLeadingNotSpace(this, startIndex);
    }

    @Override
    public final int countLeadingSpace(int startIndex, int endIndex) {
        return SequenceUtils.countLeadingSpace(this, startIndex, endIndex);
    }

    @Override
    public final int countLeadingNotSpace(int startIndex, int endIndex) {
        return SequenceUtils.countLeadingNotSpace(this, startIndex, endIndex);
    }

    @Override
    public final int countTrailingSpace() {
        return SequenceUtils.countTrailingSpace(this);
    }

    @Override
    public final int countTrailingNotSpace() {
        return SequenceUtils.countTrailingNotSpace(this);
    }

    @Override
    public final int countTrailingSpace(int fromIndex) {
        return SequenceUtils.countTrailingSpace(this, fromIndex);
    }

    @Override
    public final int countTrailingNotSpace(int fromIndex) {
        return SequenceUtils.countTrailingNotSpace(this, fromIndex);
    }

    @Override
    public final int countTrailingSpace(int startIndex, int fromIndex) {
        return SequenceUtils.countTrailingSpace(this, startIndex, fromIndex);
    }

    @Override
    public final int countTrailingNotSpace(int startIndex, int fromIndex) {
        return SequenceUtils.countTrailingNotSpace(this, startIndex, fromIndex);
    }

    @Override
    public final int countLeadingSpaceTab() {
        return SequenceUtils.countLeadingSpaceTab(this);
    }

    @Override
    public final int countLeadingNotSpaceTab() {
        return SequenceUtils.countLeadingNotSpaceTab(this);
    }

    @Override
    public final int countLeadingSpaceTab(int startIndex) {
        return SequenceUtils.countLeadingSpaceTab(this, startIndex);
    }

    @Override
    public final int countLeadingNotSpaceTab(int startIndex) {
        return SequenceUtils.countLeadingNotSpaceTab(this, startIndex);
    }

    @Override
    public final int countLeadingSpaceTab(int startIndex, int endIndex) {
        return SequenceUtils.countLeadingSpaceTab(this, startIndex, endIndex);
    }

    @Override
    public final int countLeadingNotSpaceTab(int startIndex, int endIndex) {
        return SequenceUtils.countLeadingNotSpaceTab(this, startIndex, endIndex);
    }

    @Override
    public final int countTrailingSpaceTab() {
        return SequenceUtils.countTrailingSpaceTab(this);
    }

    @Override
    public final int countTrailingNotSpaceTab() {
        return SequenceUtils.countTrailingNotSpaceTab(this);
    }

    @Override
    public final int countTrailingSpaceTab(int fromIndex) {
        return SequenceUtils.countTrailingSpaceTab(this, fromIndex);
    }

    @Override
    public final int countTrailingNotSpaceTab(int fromIndex) {
        return SequenceUtils.countTrailingNotSpaceTab(this, fromIndex);
    }

    @Override
    public final int countTrailingSpaceTab(int startIndex, int fromIndex) {
        return SequenceUtils.countTrailingSpaceTab(this, startIndex, fromIndex);
    }

    @Override
    public final int countTrailingNotSpaceTab(int startIndex, int fromIndex) {
        return SequenceUtils.countTrailingNotSpaceTab(this, startIndex, fromIndex);
    }

    @Override
    public final int countLeadingWhitespace() {
        return SequenceUtils.countLeadingWhitespace(this);
    }

    @Override
    public final int countLeadingNotWhitespace() {
        return SequenceUtils.countLeadingNotWhitespace(this);
    }

    @Override
    public final int countLeadingWhitespace(int startIndex) {
        return SequenceUtils.countLeadingWhitespace(this, startIndex);
    }

    @Override
    public final int countLeadingNotWhitespace(int startIndex) {
        return SequenceUtils.countLeadingNotWhitespace(this, startIndex);
    }

    @Override
    public final int countLeadingWhitespace(int startIndex, int endIndex) {
        return SequenceUtils.countLeadingWhitespace(this, startIndex, endIndex);
    }

    @Override
    public final int countLeadingNotWhitespace(int startIndex, int endIndex) {
        return SequenceUtils.countLeadingNotWhitespace(this, startIndex, endIndex);
    }

    @Override
    public final int countTrailingWhitespace() {
        return SequenceUtils.countTrailingWhitespace(this);
    }

    @Override
    public final int countTrailingNotWhitespace() {
        return SequenceUtils.countTrailingNotWhitespace(this);
    }

    @Override
    public final int countTrailingWhitespace(int fromIndex) {
        return SequenceUtils.countTrailingWhitespace(this, fromIndex);
    }

    @Override
    public final int countTrailingNotWhitespace(int fromIndex) {
        return SequenceUtils.countTrailingNotWhitespace(this, fromIndex);
    }

    @Override
    public final int countTrailingWhitespace(int startIndex, int fromIndex) {
        return SequenceUtils.countTrailingWhitespace(this, startIndex, fromIndex);
    }

    @Override
    public final int countTrailingNotWhitespace(int startIndex, int fromIndex) {
        return SequenceUtils.countTrailingNotWhitespace(this, startIndex, fromIndex);
    }

    @Override
    @NotNull
    public final T trimStart(@NotNull CharPredicate chars) {
        return this.subSequence(this.trimStartRange(0, chars));
    }

    @Override
    @NotNull
    public final T trimmedStart(@NotNull CharPredicate chars) {
        return this.trimmedStart(0, chars);
    }

    @Override
    @NotNull
    public final T trimEnd(@NotNull CharPredicate chars) {
        return this.trimEnd(0, chars);
    }

    @Override
    @NotNull
    public final T trimmedEnd(@NotNull CharPredicate chars) {
        return this.trimmedEnd(0, chars);
    }

    @Override
    @NotNull
    public final T trim(@NotNull CharPredicate chars) {
        return this.trim(0, chars);
    }

    @Override
    @NotNull
    public final Pair<T, T> trimmed(@NotNull CharPredicate chars) {
        return this.trimmed(0, chars);
    }

    @Override
    @NotNull
    public final T trimStart(int keep) {
        return this.trimStart(keep, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimmedStart(int keep) {
        return this.trimmedStart(keep, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimEnd(int keep) {
        return this.trimEnd(keep, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimmedEnd(int keep) {
        return this.trimmedEnd(keep, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trim(int keep) {
        return this.trim(keep, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final Pair<T, T> trimmed(int keep) {
        return this.trimmed(keep, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimStart() {
        return this.trimStart(0, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimmedStart() {
        return this.trimmedStart(0, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimEnd() {
        return this.trimEnd(0, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimmedEnd() {
        return this.trimmedEnd(0, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trim() {
        return this.trim(0, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final Pair<T, T> trimmed() {
        return this.trimmed(0, CharPredicate.WHITESPACE);
    }

    @Override
    @NotNull
    public final T trimStart(int keep, @NotNull CharPredicate chars) {
        return this.subSequence(this.trimStartRange(keep, chars));
    }

    @Override
    @NotNull
    public final T trimmedStart(int keep, @NotNull CharPredicate chars) {
        return this.subSequenceBefore(this.trimStartRange(keep, chars));
    }

    @Override
    @NotNull
    public final T trimEnd(int keep, @NotNull CharPredicate chars) {
        return this.subSequence(this.trimEndRange(keep, chars));
    }

    @Override
    @NotNull
    public final T trimmedEnd(int keep, @NotNull CharPredicate chars) {
        return this.subSequenceAfter(this.trimEndRange(keep, chars));
    }

    @Override
    @NotNull
    public final T trim(int keep, @NotNull CharPredicate chars) {
        return this.subSequence(this.trimRange(keep, chars));
    }

    @Override
    @NotNull
    public final Pair<T, T> trimmed(int keep, @NotNull CharPredicate chars) {
        return this.subSequenceBeforeAfter(this.trimRange(keep, chars));
    }

    @Override
    @NotNull
    public final Range trimStartRange(int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.trimStartRange(this, keep, chars);
    }

    @Override
    @NotNull
    public final Range trimEndRange(int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.trimEndRange(this, keep, chars);
    }

    @Override
    @NotNull
    public final Range trimRange(int keep, @NotNull CharPredicate chars) {
        return SequenceUtils.trimRange(this, keep, chars);
    }

    @Override
    @NotNull
    public final Range trimStartRange(@NotNull CharPredicate chars) {
        return SequenceUtils.trimStartRange((CharSequence)this, chars);
    }

    @Override
    @NotNull
    public final Range trimEndRange(@NotNull CharPredicate chars) {
        return SequenceUtils.trimEndRange((CharSequence)this, chars);
    }

    @Override
    @NotNull
    public final Range trimRange(@NotNull CharPredicate chars) {
        return SequenceUtils.trimRange((CharSequence)this, chars);
    }

    @Override
    @NotNull
    public final Range trimStartRange(int keep) {
        return SequenceUtils.trimStartRange((CharSequence)this, keep);
    }

    @Override
    @NotNull
    public final Range trimEndRange(int keep) {
        return SequenceUtils.trimEndRange((CharSequence)this, keep);
    }

    @Override
    @NotNull
    public final Range trimRange(int keep) {
        return SequenceUtils.trimRange((CharSequence)this, keep);
    }

    @Override
    @NotNull
    public final Range trimStartRange() {
        return SequenceUtils.trimStartRange(this);
    }

    @Override
    @NotNull
    public final Range trimEndRange() {
        return SequenceUtils.trimEndRange(this);
    }

    @Override
    @NotNull
    public final Range trimRange() {
        return SequenceUtils.trimRange(this);
    }

    @Override
    @NotNull
    public final T padding(int length, char pad) {
        return length <= this.length() ? this.nullSequence() : this.sequenceOf(RepeatedSequence.repeatOf(pad, length - this.length()));
    }

    @Override
    @NotNull
    public final T padding(int length) {
        return this.padStart(length, ' ');
    }

    @Override
    @NotNull
    public T padStart(int length, char pad) {
        T padding = this.padding(length, pad);
        return (T)(padding.isEmpty() ? this : (IRichSequence)this.getBuilder().append((CharSequence)padding).append(this).toSequence());
    }

    @Override
    @NotNull
    public T padEnd(int length, char pad) {
        T padding = this.padding(length, pad);
        return (T)(padding.isEmpty() ? this : (IRichSequence)this.getBuilder().append(this).append((CharSequence)padding).toSequence());
    }

    @Override
    @NotNull
    public T padStart(int length) {
        return this.padStart(length, ' ');
    }

    @Override
    @NotNull
    public T padEnd(int length) {
        return this.padEnd(length, ' ');
    }

    @Override
    public final int eolEndLength() {
        return SequenceUtils.eolEndLength(this);
    }

    @Override
    public final int eolEndLength(int eolEnd) {
        return SequenceUtils.eolEndLength(this, eolEnd);
    }

    @Override
    public final int eolStartLength(int eolStart) {
        return SequenceUtils.eolStartLength(this, eolStart);
    }

    @Override
    public final int endOfLine(int index) {
        return SequenceUtils.endOfLine(this, index);
    }

    @Override
    public final int endOfLineAnyEOL(int index) {
        return SequenceUtils.endOfLineAnyEOL(this, index);
    }

    @Override
    public final int startOfLine(int index) {
        return SequenceUtils.startOfLine(this, index);
    }

    @Override
    public final int startOfLineAnyEOL(int index) {
        return SequenceUtils.startOfLineAnyEOL(this, index);
    }

    @Override
    public final int startOfDelimitedByAnyNot(@NotNull CharPredicate s, int index) {
        return this.startOfDelimitedByAny(s.negate(), index);
    }

    @Override
    public final int endOfDelimitedByAnyNot(@NotNull CharPredicate s, int index) {
        return this.endOfDelimitedByAny(s.negate(), index);
    }

    @Override
    public final int startOfDelimitedBy(@NotNull CharSequence s, int index) {
        return SequenceUtils.startOfDelimitedBy(this, s, index);
    }

    @Override
    public final int startOfDelimitedByAny(@NotNull CharPredicate s, int index) {
        return SequenceUtils.startOfDelimitedByAny(this, s, index);
    }

    @Override
    public final int endOfDelimitedBy(@NotNull CharSequence s, int index) {
        return SequenceUtils.endOfDelimitedBy(this, s, index);
    }

    @Override
    public final int endOfDelimitedByAny(@NotNull CharPredicate s, int index) {
        return SequenceUtils.endOfDelimitedByAny(this, s, index);
    }

    @Override
    @NotNull
    public final Range lineRangeAt(int index) {
        return SequenceUtils.lineRangeAt(this, index);
    }

    @Override
    @NotNull
    public final Range lineRangeAtAnyEOL(int index) {
        return SequenceUtils.lineRangeAtAnyEOL(this, index);
    }

    @Override
    @NotNull
    public final T lineAt(int index) {
        return this.subSequence(this.lineRangeAt(index));
    }

    @Override
    @NotNull
    public final T lineAtAnyEOL(int index) {
        return this.subSequence(this.lineRangeAtAnyEOL(index));
    }

    @Override
    @NotNull
    public final Range eolEndRange(int eolEnd) {
        return SequenceUtils.eolEndRange(this, eolEnd);
    }

    @Override
    @NotNull
    public Range eolStartRange(int eolStart) {
        return SequenceUtils.eolStartRange(this, eolStart);
    }

    @Override
    @NotNull
    public final T trimEOL() {
        int eolLength = this.eolEndLength();
        return (T)(eolLength > 0 ? this.subSequence(0, this.length() - eolLength) : this);
    }

    @Override
    @NotNull
    public final T trimmedEOL() {
        int eolLength = this.eolEndLength();
        return eolLength > 0 ? this.subSequence(this.length() - eolLength) : this.nullSequence();
    }

    @Override
    @NotNull
    public final T trimTailBlankLines() {
        Range range = this.trailingBlankLinesRange();
        return (T)(range.isNull() ? this : this.subSequenceBefore(range));
    }

    @Override
    @NotNull
    public final T trimLeadBlankLines() {
        Range range = this.leadingBlankLinesRange();
        return (T)(range.isNull() ? this : this.subSequenceAfter(range));
    }

    @Override
    @NotNull
    public final Range leadingBlankLinesRange() {
        return SequenceUtils.leadingBlankLinesRange(this);
    }

    @Override
    @NotNull
    public final Range leadingBlankLinesRange(int startIndex) {
        return SequenceUtils.leadingBlankLinesRange(this, startIndex);
    }

    @Override
    @NotNull
    public final Range leadingBlankLinesRange(int fromIndex, int endIndex) {
        return SequenceUtils.leadingBlankLinesRange(this, fromIndex, endIndex);
    }

    @Override
    @NotNull
    public final Range trailingBlankLinesRange() {
        return SequenceUtils.trailingBlankLinesRange(this);
    }

    @Override
    @NotNull
    public final Range trailingBlankLinesRange(int fromIndex) {
        return SequenceUtils.trailingBlankLinesRange(this, fromIndex);
    }

    @Override
    @NotNull
    public final Range trailingBlankLinesRange(int startIndex, int fromIndex) {
        return SequenceUtils.trailingBlankLinesRange(this, startIndex, fromIndex);
    }

    @Override
    @NotNull
    public final Range trailingBlankLinesRange(CharPredicate eolChars, int startIndex, int fromIndex) {
        return SequenceUtils.trailingBlankLinesRange(this, eolChars, startIndex, fromIndex);
    }

    @Override
    @NotNull
    public final Range leadingBlankLinesRange(@NotNull CharPredicate eolChars, int fromIndex, int endIndex) {
        return SequenceUtils.leadingBlankLinesRange(this, eolChars, fromIndex, endIndex);
    }

    @Override
    @NotNull
    public final List<Range> blankLinesRemovedRanges() {
        return SequenceUtils.blankLinesRemovedRanges(this);
    }

    @Override
    @NotNull
    public final List<Range> blankLinesRemovedRanges(int fromIndex) {
        return SequenceUtils.blankLinesRemovedRanges(this, fromIndex);
    }

    @Override
    @NotNull
    public final List<Range> blankLinesRemovedRanges(int fromIndex, int endIndex) {
        return SequenceUtils.blankLinesRemovedRanges(this, fromIndex, endIndex);
    }

    @Override
    @NotNull
    public final List<Range> blankLinesRemovedRanges(@NotNull CharPredicate eolChars, int fromIndex, int endIndex) {
        return SequenceUtils.blankLinesRemovedRanges(this, eolChars, fromIndex, endIndex);
    }

    @Override
    @NotNull
    public T trimToEndOfLine(boolean includeEol) {
        return this.trimToEndOfLine(CharPredicate.EOL, includeEol, 0);
    }

    @Override
    @NotNull
    public T trimToEndOfLine(int index) {
        return this.trimToEndOfLine(CharPredicate.EOL, false, index);
    }

    @Override
    @NotNull
    public T trimToEndOfLine() {
        return this.trimToEndOfLine(CharPredicate.EOL, false, 0);
    }

    @Override
    @NotNull
    public T trimToEndOfLine(boolean includeEol, int index) {
        return this.trimToEndOfLine(CharPredicate.EOL, includeEol, index);
    }

    @Override
    @NotNull
    public T trimToStartOfLine(boolean includeEol) {
        return this.trimToStartOfLine(CharPredicate.EOL, includeEol, 0);
    }

    @Override
    @NotNull
    public T trimToStartOfLine(int index) {
        return this.trimToStartOfLine(CharPredicate.EOL, false, index);
    }

    @Override
    @NotNull
    public T trimToStartOfLine() {
        return this.trimToStartOfLine(CharPredicate.EOL, false, 0);
    }

    @Override
    @NotNull
    public T trimToStartOfLine(boolean includeEol, int index) {
        return this.trimToStartOfLine(CharPredicate.EOL, includeEol, index);
    }

    @Override
    @NotNull
    public T trimToEndOfLine(@NotNull CharPredicate eolChars, boolean includeEol, int index) {
        int eolPos = this.endOfDelimitedByAny(eolChars, index);
        if (eolPos < this.length()) {
            int endIndex = includeEol ? eolPos + this.eolStartLength(eolPos) : eolPos;
            return (T)this.subSequence(0, endIndex);
        }
        return (T)this;
    }

    @Override
    @NotNull
    public T trimToStartOfLine(@NotNull CharPredicate eolChars, boolean includeEol, int index) {
        int eolPos = this.startOfDelimitedByAny(eolChars, index);
        if (eolPos > 0) {
            int startIndex = includeEol ? eolPos - this.eolEndLength(eolPos - 1) : eolPos;
            return this.subSequence(startIndex);
        }
        return (T)this;
    }

    @Override
    @NotNull
    public final T ifNull(@NotNull T other) {
        return (T)(this.isNull() ? other : this);
    }

    @Override
    @NotNull
    public final T ifNullEmptyAfter(@NotNull T other) {
        return (T)(this.isNull() ? other.subSequence(other.length(), other.length()) : this);
    }

    @Override
    @NotNull
    public final T ifNullEmptyBefore(@NotNull T other) {
        return (T)(this.isNull() ? other.subSequence(0, 0) : this);
    }

    @Override
    @NotNull
    public final T nullIfEmpty() {
        return (T)(this.isEmpty() ? this.nullSequence() : this);
    }

    @Override
    @NotNull
    public final T nullIfBlank() {
        return (T)(this.isBlank() ? this.nullSequence() : this);
    }

    @Override
    @NotNull
    public final T nullIf(boolean condition) {
        return (T)(condition ? this.nullSequence() : this);
    }

    @Override
    @NotNull
    public final T nullIfNot(@NotNull BiPredicate<? super T, ? super CharSequence> predicate, CharSequence ... matches) {
        return this.nullIf(predicate.negate(), matches);
    }

    @Override
    @NotNull
    public final T nullIf(@NotNull Predicate<? super CharSequence> predicate, CharSequence ... matches) {
        return (T)this.nullIf((? super T o1, ? super CharSequence o2) -> predicate.test((CharSequence)o2), matches);
    }

    @Override
    @NotNull
    public final T nullIfNot(@NotNull Predicate<? super CharSequence> predicate, CharSequence ... matches) {
        return (T)this.nullIfNot((? super T o1, ? super CharSequence o2) -> predicate.test((CharSequence)o2), matches);
    }

    @Override
    @NotNull
    public final T nullIf(CharSequence ... matches) {
        return this.nullIf(this::matches, matches);
    }

    @Override
    @NotNull
    public final T nullIfNot(CharSequence ... matches) {
        return this.nullIfNot(this::matches, matches);
    }

    @Override
    @NotNull
    public final T nullIfStartsWith(CharSequence ... matches) {
        return this.nullIf(this::startsWith, matches);
    }

    @Override
    @NotNull
    public final T nullIfNotStartsWith(CharSequence ... matches) {
        return this.nullIfNot(this::startsWith, matches);
    }

    @Override
    @NotNull
    public final T nullIfEndsWith(CharSequence ... matches) {
        return this.nullIf(this::endsWith, matches);
    }

    @Override
    @NotNull
    public final T nullIfNotEndsWith(CharSequence ... matches) {
        return this.nullIfNot(this::endsWith, matches);
    }

    @Override
    @NotNull
    public final T nullIfStartsWithIgnoreCase(CharSequence ... matches) {
        return this.nullIf(this::startsWithIgnoreCase, matches);
    }

    @Override
    @NotNull
    public final T nullIfNotStartsWithIgnoreCase(CharSequence ... matches) {
        return this.nullIfNot(this::startsWithIgnoreCase, matches);
    }

    @Override
    @NotNull
    public final T nullIfEndsWithIgnoreCase(CharSequence ... matches) {
        return this.nullIf(this::endsWithIgnoreCase, matches);
    }

    @Override
    @NotNull
    public final T nullIfNotEndsWithIgnoreCase(CharSequence ... matches) {
        return this.nullIfNot(this::endsWithIgnoreCase, matches);
    }

    @Override
    @NotNull
    public final T nullIfStartsWith(boolean ignoreCase, CharSequence ... matches) {
        return this.nullIf((? super CharSequence prefix) -> this.startsWith((CharSequence)prefix, ignoreCase), matches);
    }

    @Override
    @NotNull
    public final T nullIfNotStartsWith(boolean ignoreCase, CharSequence ... matches) {
        return this.nullIfNot((? super CharSequence prefix) -> this.startsWith((CharSequence)prefix, ignoreCase), matches);
    }

    @Override
    @NotNull
    public final T nullIfEndsWith(boolean ignoreCase, CharSequence ... matches) {
        return this.nullIf((? super CharSequence suffix) -> this.endsWith((CharSequence)suffix, ignoreCase), matches);
    }

    @Override
    @NotNull
    public final T nullIfNotEndsWith(boolean ignoreCase, CharSequence ... matches) {
        return this.nullIfNot((? super CharSequence suffix) -> this.endsWith((CharSequence)suffix, ignoreCase), matches);
    }

    @Override
    @NotNull
    public final T nullIf(@NotNull BiPredicate<? super T, ? super CharSequence> predicate, CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!predicate.test(this, match)) continue;
            return this.nullSequence();
        }
        return (T)this;
    }

    @Override
    public final boolean isNull() {
        return this == this.nullSequence();
    }

    @Override
    public final boolean isNotNull() {
        return this != this.nullSequence();
    }

    @Override
    public final boolean isEmpty() {
        return SequenceUtils.isEmpty(this);
    }

    @Override
    public final boolean isBlank() {
        return SequenceUtils.isBlank(this);
    }

    @Override
    public final boolean isNotEmpty() {
        return SequenceUtils.isNotEmpty(this);
    }

    @Override
    public final boolean isNotBlank() {
        return SequenceUtils.isNotBlank(this);
    }

    @Override
    public final boolean endsWith(@NotNull CharSequence suffix) {
        return SequenceUtils.endsWith((CharSequence)this, suffix);
    }

    @Override
    public final boolean endsWith(@NotNull CharSequence suffix, boolean ignoreCase) {
        return SequenceUtils.endsWith(this, suffix, ignoreCase);
    }

    @Override
    public final boolean startsWith(@NotNull CharSequence prefix) {
        return SequenceUtils.startsWith((CharSequence)this, prefix);
    }

    @Override
    public final boolean startsWith(@NotNull CharSequence prefix, boolean ignoreCase) {
        return SequenceUtils.startsWith(this, prefix, ignoreCase);
    }

    @Override
    public final boolean endsWith(@NotNull CharPredicate chars) {
        return SequenceUtils.endsWith((CharSequence)this, chars);
    }

    @Override
    public final boolean startsWith(@NotNull CharPredicate chars) {
        return SequenceUtils.startsWith((CharSequence)this, chars);
    }

    @Override
    public final boolean endsWithEOL() {
        return SequenceUtils.endsWithEOL(this);
    }

    @Override
    public final boolean endsWithAnyEOL() {
        return SequenceUtils.endsWithAnyEOL(this);
    }

    @Override
    public final boolean endsWithSpace() {
        return SequenceUtils.endsWithSpace(this);
    }

    @Override
    public final boolean endsWithSpaceTab() {
        return SequenceUtils.endsWithSpaceTab(this);
    }

    @Override
    public final boolean endsWithWhitespace() {
        return SequenceUtils.endsWithWhitespace(this);
    }

    @Override
    public final boolean startsWithEOL() {
        return SequenceUtils.startsWithEOL(this);
    }

    @Override
    public final boolean startsWithAnyEOL() {
        return SequenceUtils.startsWithAnyEOL(this);
    }

    @Override
    public final boolean startsWithSpace() {
        return SequenceUtils.startsWithSpace(this);
    }

    @Override
    public final boolean startsWithSpaceTab() {
        return SequenceUtils.startsWithSpaceTab(this);
    }

    @Override
    public final boolean startsWithWhitespace() {
        return SequenceUtils.startsWithWhitespace(this);
    }

    @Override
    @NotNull
    public final T removeSuffix(@NotNull CharSequence suffix) {
        return (T)(!this.endsWith(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    @NotNull
    public final T removePrefix(@NotNull CharSequence prefix) {
        return (T)(!this.startsWith(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    @NotNull
    public final T removeProperSuffix(@NotNull CharSequence suffix) {
        return (T)(this.length() <= suffix.length() || !this.endsWith(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    @NotNull
    public final T removeProperPrefix(@NotNull CharSequence prefix) {
        return (T)(this.length() <= prefix.length() || !this.startsWith(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    public final boolean endsWithIgnoreCase(@NotNull CharSequence suffix) {
        return this.length() > 0 && this.matchCharsReversed(suffix, this.length() - 1, true);
    }

    @Override
    public final boolean startsWithIgnoreCase(@NotNull CharSequence prefix) {
        return this.length() > 0 && this.matchChars(prefix, 0, true);
    }

    @Override
    @NotNull
    public final T removeSuffixIgnoreCase(@NotNull CharSequence suffix) {
        return (T)(!this.endsWithIgnoreCase(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    @NotNull
    public final T removePrefixIgnoreCase(@NotNull CharSequence prefix) {
        return (T)(!this.startsWithIgnoreCase(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    @NotNull
    public final T removeProperSuffixIgnoreCase(@NotNull CharSequence suffix) {
        return (T)(this.length() <= suffix.length() || !this.endsWithIgnoreCase(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    @NotNull
    public final T removeProperPrefixIgnoreCase(@NotNull CharSequence prefix) {
        return (T)(this.length() <= prefix.length() || !this.startsWithIgnoreCase(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    @NotNull
    public final T removeSuffix(@NotNull CharSequence suffix, boolean ignoreCase) {
        return (T)(!this.endsWith(suffix, ignoreCase) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    @NotNull
    public final T removePrefix(@NotNull CharSequence prefix, boolean ignoreCase) {
        return (T)(!this.startsWith(prefix, ignoreCase) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    @NotNull
    public final T removeProperSuffix(@NotNull CharSequence suffix, boolean ignoreCase) {
        return (T)(this.length() <= suffix.length() || !this.endsWith(suffix, ignoreCase) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    @NotNull
    public final T removeProperPrefix(@NotNull CharSequence prefix, boolean ignoreCase) {
        return (T)(this.length() <= prefix.length() || !this.startsWith(prefix, ignoreCase) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    @NotNull
    public T insert(int index, @NotNull CharSequence chars) {
        index = Math.max(0, Math.min(this.length(), index));
        if (chars.length() == 0) {
            return (T)this;
        }
        if (index == 0) {
            return this.prefixWith(chars);
        }
        if (index == this.length()) {
            return this.suffixWith(chars);
        }
        return (T)((IRichSequence)this.getBuilder().add(this.subSequence(0, index)).add(chars).add((CharSequence)this.subSequence(index)).toSequence());
    }

    @Override
    @NotNull
    public T delete(int startIndex, int endIndex) {
        endIndex = Math.max(0, Math.min(this.length(), endIndex));
        startIndex = Math.min(endIndex, Math.max(0, startIndex));
        if (startIndex == endIndex) {
            return (T)this;
        }
        if (startIndex == 0) {
            return this.subSequence(endIndex);
        }
        if (endIndex == this.length()) {
            return (T)this.subSequence(0, startIndex);
        }
        return (T)((IRichSequence)this.getBuilder().add(this.subSequence(0, startIndex)).add((CharSequence)this.subSequence(endIndex)).toSequence());
    }

    @Override
    @NotNull
    public final T toLowerCase() {
        return this.toMapped(ChangeCase.toLowerCase);
    }

    @Override
    @NotNull
    public final T toUpperCase() {
        return this.toMapped(ChangeCase.toUpperCase);
    }

    @Override
    @NotNull
    public final T toNbSp() {
        return this.toMapped(SpaceMapper.toNonBreakSpace);
    }

    @Override
    @NotNull
    public final T toSpc() {
        return this.toMapped(SpaceMapper.fromNonBreakSpace);
    }

    @Override
    public final boolean matches(@NotNull CharSequence chars, boolean ignoreCase) {
        return SequenceUtils.matches(this, chars, ignoreCase);
    }

    @Override
    public final boolean matches(@NotNull CharSequence chars) {
        return SequenceUtils.matches(this, chars);
    }

    @Override
    public final boolean matchesIgnoreCase(@NotNull CharSequence chars) {
        return SequenceUtils.matchesIgnoreCase(this, chars);
    }

    @Override
    public final boolean matchChars(@NotNull CharSequence chars, int startIndex, boolean ignoreCase) {
        return SequenceUtils.matchChars(this, chars, startIndex, ignoreCase);
    }

    @Override
    public final boolean matchChars(@NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchChars((CharSequence)this, chars, startIndex);
    }

    @Override
    public final boolean matchCharsIgnoreCase(@NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchCharsIgnoreCase(this, chars, startIndex);
    }

    @Override
    public final boolean matchChars(@NotNull CharSequence chars, boolean ignoreCase) {
        return SequenceUtils.matchChars((CharSequence)this, chars, ignoreCase);
    }

    @Override
    public final boolean matchChars(@NotNull CharSequence chars) {
        return SequenceUtils.matchChars(this, chars);
    }

    @Override
    public final boolean matchCharsIgnoreCase(@NotNull CharSequence chars) {
        return SequenceUtils.matchCharsIgnoreCase(this, chars);
    }

    @Override
    public final boolean matchCharsReversed(@NotNull CharSequence chars, int endIndex, boolean ignoreCase) {
        return SequenceUtils.matchCharsReversed(this, chars, endIndex, ignoreCase);
    }

    @Override
    public final boolean matchCharsReversed(@NotNull CharSequence chars, int endIndex) {
        return SequenceUtils.matchCharsReversed(this, chars, endIndex);
    }

    @Override
    public final boolean matchCharsReversedIgnoreCase(@NotNull CharSequence chars, int endIndex) {
        return SequenceUtils.matchCharsReversedIgnoreCase(this, chars, endIndex);
    }

    @Override
    public final int matchedCharCount(@NotNull CharSequence chars, int startIndex, int endIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCount(this, chars, startIndex, endIndex, ignoreCase);
    }

    @Override
    public final int matchedCharCount(@NotNull CharSequence chars, int startIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCount((CharSequence)this, chars, startIndex, ignoreCase);
    }

    @Override
    public final int matchedCharCount(@NotNull CharSequence chars, int startIndex, int endIndex) {
        return SequenceUtils.matchedCharCount((CharSequence)this, chars, startIndex, endIndex);
    }

    @Override
    public final int matchedCharCount(@NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchedCharCount(this, chars, startIndex);
    }

    @Override
    public final int matchedCharCountIgnoreCase(@NotNull CharSequence chars, int startIndex) {
        return SequenceUtils.matchedCharCountIgnoreCase(this, chars, startIndex);
    }

    @Override
    public final int matchedCharCountIgnoreCase(@NotNull CharSequence chars, int startIndex, int endIndex) {
        return SequenceUtils.matchedCharCountIgnoreCase(this, chars, startIndex, endIndex);
    }

    @Override
    public final int matchedCharCountReversedIgnoreCase(@NotNull CharSequence chars, int startIndex, int fromIndex) {
        return SequenceUtils.matchedCharCountReversedIgnoreCase(this, chars, startIndex, fromIndex);
    }

    @Override
    public final int matchedCharCountReversed(@NotNull CharSequence chars, int startIndex, int fromIndex) {
        return SequenceUtils.matchedCharCountReversed((CharSequence)this, chars, startIndex, fromIndex);
    }

    @Override
    public final int matchedCharCountReversed(@NotNull CharSequence chars, int fromIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCountReversed((CharSequence)this, chars, fromIndex, ignoreCase);
    }

    @Override
    public final int matchedCharCountReversed(@NotNull CharSequence chars, int fromIndex) {
        return SequenceUtils.matchedCharCountReversed(this, chars, fromIndex);
    }

    @Override
    public final int matchedCharCountReversedIgnoreCase(@NotNull CharSequence chars, int fromIndex) {
        return SequenceUtils.matchedCharCountReversedIgnoreCase(this, chars, fromIndex);
    }

    @Override
    public final int matchedCharCount(@NotNull CharSequence chars, int startIndex, int endIndex, boolean fullMatchOnly, boolean ignoreCase) {
        return SequenceUtils.matchedCharCount(this, chars, startIndex, endIndex, fullMatchOnly, ignoreCase);
    }

    @Override
    public final int matchedCharCountReversed(@NotNull CharSequence chars, int startIndex, int fromIndex, boolean ignoreCase) {
        return SequenceUtils.matchedCharCountReversed(this, chars, startIndex, fromIndex, ignoreCase);
    }

    @Override
    @NotNull
    public String toString() {
        int iMax = this.length();
        StringBuilder sb = new StringBuilder(iMax);
        for (int i = 0; i < iMax; ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public final String normalizeEOL() {
        return Escaping.normalizeEOL(this.toString());
    }

    @Override
    @NotNull
    public final String normalizeEndWithEOL() {
        return Escaping.normalizeEndWithEOL(this.toString());
    }

    @Override
    @NotNull
    public final String toVisibleWhitespaceString() {
        return SequenceUtils.toVisibleWhitespaceString(this);
    }

    @Override
    @NotNull
    public final List<T> splitList(@NotNull CharSequence delimiter) {
        return SequenceUtils.splitList(this, delimiter, 0, 0, null);
    }

    @Override
    @NotNull
    public final List<T> splitList(@NotNull CharSequence delimiter, int limit, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(this, delimiter, limit, includeDelims ? 1 : 0, trimChars);
    }

    @Override
    @NotNull
    public final List<T> splitList(@NotNull CharSequence delimiter, int limit, int flags) {
        return SequenceUtils.splitList(this, delimiter, limit, flags, null);
    }

    @Override
    @NotNull
    public final List<T> splitList(@NotNull CharSequence delimiter, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(this, delimiter, 0, includeDelims ? 1 : 0, trimChars);
    }

    @Override
    @NotNull
    public final List<T> splitListEOL() {
        return SequenceUtils.splitList(this, (CharSequence)"\n", 0, 1, null);
    }

    @Override
    @NotNull
    public final List<T> splitListEOL(boolean includeDelims) {
        return SequenceUtils.splitList(this, (CharSequence)"\n", 0, includeDelims ? 1 : 0, null);
    }

    @Override
    @NotNull
    public final List<T> splitListEOL(boolean includeDelims, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(this, (CharSequence)"\n", 0, includeDelims ? 1 : 0, trimChars);
    }

    @Override
    @NotNull
    public final List<T> splitList(@NotNull CharSequence delimiter, int limit, int flags, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(this, delimiter, limit, flags, trimChars);
    }

    @Override
    @NotNull
    public final T[] splitEOL() {
        return this.split("\n", 0, 1, null);
    }

    @Override
    @NotNull
    public final T[] splitEOL(boolean includeDelims) {
        return this.split("\n", 0, includeDelims ? 1 : 0, null);
    }

    @Override
    @NotNull
    public final T[] split(@NotNull CharSequence delimiter, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return this.split(delimiter, 0, includeDelims ? 1 : 0, trimChars);
    }

    @Override
    @NotNull
    public final T[] split(@NotNull CharSequence delimiter) {
        return this.split(delimiter, 0, 0, null);
    }

    @Override
    @NotNull
    public final T[] split(@NotNull CharSequence delimiter, int limit, boolean includeDelims, @Nullable CharPredicate trimChars) {
        return this.split(delimiter, limit, includeDelims ? 1 : 0, trimChars);
    }

    @Override
    @NotNull
    public final T[] split(@NotNull CharSequence delimiter, int limit, int flags) {
        return this.split(delimiter, limit, flags, null);
    }

    @Override
    @NotNull
    public final T[] split(@NotNull CharSequence delimiter, int limit, int flags, @Nullable CharPredicate trimChars) {
        return SequenceUtils.splitList(this, delimiter, limit, flags, trimChars).toArray(this.emptyArray());
    }

    @Override
    @NotNull
    public final T appendTo(@NotNull StringBuilder out, @Nullable CharMapper charMapper) {
        return this.appendTo(out, charMapper, 0, this.length());
    }

    @Override
    @NotNull
    public final T appendTo(@NotNull StringBuilder out, @Nullable CharMapper charMapper, int startIndex) {
        return this.appendTo(out, charMapper, startIndex, this.length());
    }

    @Override
    @NotNull
    public final T appendTo(@NotNull StringBuilder out) {
        return this.appendTo(out, null, 0, this.length());
    }

    @Override
    @NotNull
    public final T appendTo(@NotNull StringBuilder out, int startIndex) {
        return this.appendTo(out, null, startIndex, this.length());
    }

    @Override
    @NotNull
    public final T appendTo(@NotNull StringBuilder out, int startIndex, int endIndex) {
        return this.appendTo(out, null, startIndex, endIndex);
    }

    @Override
    @NotNull
    public final T appendTo(@NotNull StringBuilder out, @Nullable CharMapper charMapper, int startIndex, int endIndex) {
        IRichSequenceBase useSequence = charMapper == null ? this : this.toMapped(charMapper);
        out.append(useSequence, startIndex, endIndex);
        return (T)this;
    }

    @Override
    @NotNull
    public final T appendRangesTo(@NotNull StringBuilder out, @Nullable CharMapper charMapper, Range ... ranges) {
        return this.appendRangesTo(out, charMapper, new ArrayIterable<Range>(ranges));
    }

    @Override
    @NotNull
    public final T appendRangesTo(@NotNull StringBuilder out, Range ... ranges) {
        return this.appendRangesTo(out, null, new ArrayIterable<Range>(ranges));
    }

    @Override
    @NotNull
    public final T appendRangesTo(@NotNull StringBuilder out, Iterable<? extends Range> ranges) {
        return this.appendRangesTo(out, null, ranges);
    }

    @Override
    @NotNull
    public final T appendRangesTo(@NotNull StringBuilder out, @Nullable CharMapper charMapper, Iterable<? extends Range> ranges) {
        IRichSequenceBase useSequence = charMapper == null ? this : this.toMapped(charMapper);
        for (Range range : ranges) {
            if (range == null || !range.isNotNull()) continue;
            out.append(useSequence, range.getStart(), range.getEnd());
        }
        return (T)this;
    }

    @Override
    @NotNull
    public final int[] indexOfAll(@NotNull CharSequence s) {
        return SequenceUtils.indexOfAll(this, s);
    }

    @Override
    @NotNull
    public final T appendEOL() {
        return this.suffixWith("\n");
    }

    @Override
    @NotNull
    public final T suffixWithEOL() {
        return this.suffixWith("\n");
    }

    @Override
    @NotNull
    public final T prefixWithEOL() {
        return this.prefixWith("\n");
    }

    @Override
    @NotNull
    public final T prefixOnceWithEOL() {
        return this.prefixOnceWith("\n");
    }

    @Override
    @NotNull
    public final T suffixOnceWithEOL() {
        return this.suffixOnceWith("\n");
    }

    @Override
    @NotNull
    public final T appendSpace() {
        return this.suffixWith(" ");
    }

    @Override
    @NotNull
    public final T suffixWithSpace() {
        return this.suffixWith(" ");
    }

    @Override
    @NotNull
    public final T prefixWithSpace() {
        return this.prefixWith(" ");
    }

    @Override
    @NotNull
    public final T appendSpaces(int count) {
        return this.suffixWith(RepeatedSequence.ofSpaces(count));
    }

    @Override
    @NotNull
    public final T suffixWithSpaces(int count) {
        return this.suffixWith(RepeatedSequence.ofSpaces(count));
    }

    @Override
    @NotNull
    public final T prefixWithSpaces(int count) {
        return this.prefixWith(RepeatedSequence.ofSpaces(count));
    }

    @Override
    @NotNull
    public final T prefixOnceWithSpace() {
        return this.prefixOnceWith(" ");
    }

    @Override
    @NotNull
    public final T suffixOnceWithSpace() {
        return this.suffixOnceWith(" ");
    }

    @Override
    @NotNull
    public T prefixWith(@Nullable CharSequence prefix) {
        return (T)(prefix == null || prefix.length() == 0 ? this : (IRichSequence)this.getBuilder().add(prefix).add(this).toSequence());
    }

    @Override
    @NotNull
    public T suffixWith(@Nullable CharSequence suffix) {
        if (suffix == null || suffix.length() == 0) {
            return (T)this;
        }
        return (T)((IRichSequence)this.getBuilder().add(this).add(suffix).toSequence());
    }

    @Override
    @NotNull
    public final T prefixOnceWith(@Nullable CharSequence prefix) {
        return (T)(prefix == null || prefix.length() == 0 || this.startsWith(prefix) ? this : this.prefixWith(prefix));
    }

    @Override
    @NotNull
    public final T suffixOnceWith(@Nullable CharSequence suffix) {
        return (T)(suffix == null || suffix.length() == 0 || this.endsWith(suffix) ? this : this.suffixWith(suffix));
    }

    @Override
    @NotNull
    public final T replace(int startIndex, int endIndex, @NotNull CharSequence replacement) {
        int length = this.length();
        startIndex = Math.max(startIndex, 0);
        endIndex = Math.min(endIndex, length);
        Object segments = this.getBuilder();
        return (T)((IRichSequence)segments.add(this.subSequence(0, startIndex)).add(replacement).add((CharSequence)this.subSequence(endIndex)).toSequence());
    }

    @Override
    @NotNull
    public final T replace(@NotNull CharSequence find, @NotNull CharSequence replace) {
        int[] indices = this.indexOfAll(find);
        if (indices.length == 0) {
            return (T)this;
        }
        Object segments = this.getBuilder();
        int iMax = indices.length;
        int length = this.length();
        int i = 0;
        int lastPos = 0;
        while (i < iMax) {
            int pos;
            if (lastPos < (pos = indices[i++])) {
                segments.add(this.subSequence(lastPos, pos));
            }
            lastPos = pos + find.length();
            segments.add(replace);
        }
        if (lastPos < length) {
            segments.add(this.subSequence(lastPos, length));
        }
        return (T)((IRichSequence)segments.toSequence());
    }

    @Override
    @NotNull
    public final T append(CharSequence ... sequences) {
        return this.append(new ArrayIterable<CharSequence>(sequences));
    }

    @Override
    @NotNull
    public final T append(Iterable<? extends CharSequence> sequences) {
        Object segments = this.getBuilder();
        segments.add(this);
        for (CharSequence charSequence : sequences) {
            segments.add(charSequence);
        }
        return (T)((IRichSequence)segments.toSequence());
    }

    @Override
    @NotNull
    public final T extractRanges(Range ... ranges) {
        return this.extractRanges(new ArrayIterable<Range>(ranges));
    }

    @Override
    @NotNull
    public final T extractRanges(Iterable<Range> ranges) {
        Object segments = this.getBuilder();
        for (Range range : ranges) {
            if (range == null || range.isNull()) continue;
            segments.add(range.safeSubSequence(this));
        }
        return (T)((IRichSequence)segments.toSequence());
    }

    @Override
    public final int columnAtIndex(int index) {
        return SequenceUtils.columnAtIndex(this, index);
    }

    @Override
    @NotNull
    public final Pair<Integer, Integer> lineColumnAtIndex(int index) {
        return SequenceUtils.lineColumnAtIndex(this, index);
    }

    @Override
    public boolean isIn(@NotNull String[] texts) {
        return SequenceUtils.containedBy((CharSequence[])texts, (CharSequence)this);
    }

    @Override
    public boolean isIn(@NotNull Collection<? extends CharSequence> texts) {
        return SequenceUtils.containedBy(texts, (CharSequence)this);
    }
}

