/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import com.vladsch.flexmark.util.ast.Document;
import internal.heylogs.cli.MarkdownInputOptions;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import nbbrd.console.picocli.text.TextOutputOptions;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.FailureFormatter;
import nbbrd.heylogs.FailureFormatterLoader;
import nbbrd.heylogs.RuleLoader;
import nbbrd.heylogs.StylishFormatter;
import picocli.CommandLine;

@CommandLine.Command(name="check")
public final class CheckCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private MarkdownInputOptions input;
    @CommandLine.Mixin
    private TextOutputOptions output;
    @CommandLine.Option(names={"-f", "--format"}, defaultValue="stylish", description={"Specify the formatter used to control the appearance of the result. Valid values: ${COMPLETION-CANDIDATES}."}, completionCandidates=FormatCandidates.class)
    private String format;

    @Override
    public Integer call() throws Exception {
        List failures = Failure.allOf((Document)this.input.read(), (List)RuleLoader.load());
        try (Writer writer = this.output.newCharWriter();){
            FailureFormatterLoader.load().stream().filter(formatter -> formatter.getName().equals(this.format)).findFirst().orElse((FailureFormatter)new StylishFormatter()).format((Appendable)writer, this.input.hasFile() ? this.input.getFile().toString() : "stdin", failures);
        }
        return failures.isEmpty() ? 0 : 2;
    }

    public static final class FormatCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return FailureFormatterLoader.load().stream().map(FailureFormatter::getName).iterator();
        }
    }
}

