/*
 * Decompiled with CFR 0.152.
 */
package internal.heylogs.cli;

import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import nbbrd.console.picocli.text.TextInput;
import nbbrd.console.properties.ConsoleProperties;
import picocli.CommandLine;

public class MarkdownInputOptions
implements TextInput {
    @CommandLine.Option(names={"-i", "--input"}, paramLabel="<file>", description={"Input from a file instead of stdin."})
    private Path file;

    public boolean isGzipped() {
        return false;
    }

    public Charset getEncoding() {
        return StandardCharsets.UTF_8;
    }

    public InputStream getStdInStream() {
        return System.in;
    }

    public Charset getStdInEncoding() {
        return ConsoleProperties.ofServiceLoader().getStdInEncoding().orElse(StandardCharsets.UTF_8);
    }

    public Document read() throws IOException {
        Parser parser = Parser.builder().build();
        try (Reader reader = this.newCharReader();){
            Document document = parser.parseReader(reader);
            return document;
        }
    }

    @Generated
    public Path getFile() {
        return this.file;
    }

    @Generated
    public void setFile(Path file) {
        this.file = file;
    }
}

