/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.cli;

import com.vladsch.flexmark.util.ast.Document;
import internal.heylogs.cli.MarkdownInputOptions;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import nbbrd.heylogs.Failure;
import nbbrd.heylogs.Rule;
import picocli.CommandLine;

@CommandLine.Command(name="check")
public final class CheckCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private MarkdownInputOptions input;

    @Override
    public Integer call() throws Exception {
        List rules = Rule.getDefault();
        List failures = Failure.allOf((Document)this.input.read(), (List)rules);
        CheckCommand.printStylish(this.input.getFile(), failures);
        return failures.isEmpty() ? 0 : 2;
    }

    private static void printStylish(Path inputFile, List<Failure> failures) {
        if (inputFile != null) {
            System.out.println(inputFile);
        }
        int l = failures.stream().mapToInt(failure -> CheckCommand.getNumberOfDigits(failure.getLine())).max().orElse(0);
        int c = failures.stream().mapToInt(failure -> CheckCommand.getNumberOfDigits(failure.getColumn())).max().orElse(0);
        int m = failures.stream().mapToInt(failure -> failure.getMessage().length()).max().orElse(0);
        failures.forEach(failure -> System.out.println(String.format("  %" + l + "d:%-" + c + "d  error  %-" + m + "s  %s", failure.getLine(), failure.getColumn(), failure.getMessage(), failure.getRule())));
    }

    private static int getNumberOfDigits(int number) {
        return (int)(Math.log10(number) + 1.0);
    }
}

