/*
 * Copyright (c) 2018 - 2020 - Frank Hossfeld
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may not
 *  use this file except in compliance with the License. You may obtain a copy of
 *  the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  License for the specific language governing permissions and limitations under
 *  the License.
 */

package com.github.nalukit.nalu.client.component;

import com.github.nalukit.nalu.client.internal.annotation.NaluInternalUse;

/**
 * Controllers marked with this interface will create the component instance.
 * This is useful, if you want to use Elemento templating or GWT.create to ensure,
 * replacement rules are used!
 * <br><br>
 * In case using this interface, there must be createComponent method, that looks like that:
 * <code>
 * public IMyComponent createComponent() {
 * return new MyComponent();
 * }
 * </code>
 *
 * @param <V> type of the component's interface
 */
public interface IsComponentCreator<V extends IsComponent<?, ?>> {
  
  @NaluInternalUse
  V createComponent();
  
}
