/*
 * Copyright (c) 2020 - Frank Hossfeld
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may not
 *  use this file except in compliance with the License. You may obtain a copy of
 *  the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  License for the specific language governing permissions and limitations under
 *  the License.
 */

package com.github.nalukit.nalu.plugin.gwt.client.selector;

import java.util.HashMap;
import java.util.Map;

public class SelectorProvider {
  
  private static SelectorProvider instance = new SelectorProvider();
  
  private Map<String, SelectorCommand> selectorCommands;
  
  private SelectorProvider() {
    this.selectorCommands = new HashMap<>();
  }
  
  public static SelectorProvider get() {
    return instance;
  }
  
  public Map<String, SelectorCommand> getSelectorCommands() {
    return selectorCommands;
  }
  
}
