/*
 * Decompiled with CFR 0.152.
 */
package com.github.nalukit.nalu.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ProcessorUtils {
    private ProcessingEnvironment processingEnvironment;
    private Messager messager;
    private Elements elements;

    private ProcessorUtils(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.messager = this.processingEnvironment.getMessager();
        this.elements = this.processingEnvironment.getElementUtils();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPackageAsString(Element type) {
        return this.getPackage(type).getQualifiedName().toString();
    }

    public PackageElement getPackage(Element type) {
        while (type.getKind() != ElementKind.PACKAGE) {
            type = type.getEnclosingElement();
        }
        return (PackageElement)type;
    }

    public Elements getElements() {
        return this.elements;
    }

    public boolean extendsClassOrInterface(Types types, TypeMirror typeMirror, TypeMirror toImplement) {
        String clearedToImplement = this.removeGenericsFromClassName(toImplement.toString());
        Set<TypeMirror> setOfSuperType = this.getFlattenedSupertypeHierarchy(types, typeMirror);
        for (TypeMirror mirror : setOfSuperType) {
            if (!clearedToImplement.equals(this.removeGenericsFromClassName(mirror.toString()))) continue;
            return true;
        }
        return false;
    }

    private String removeGenericsFromClassName(String className) {
        if (className.contains("<")) {
            className = className.substring(0, className.indexOf("<"));
        }
        return className;
    }

    public Set<TypeMirror> getFlattenedSupertypeHierarchy(Types types, TypeMirror typeMirror) {
        ArrayList<? extends TypeMirror> toAdd = new ArrayList<TypeMirror>();
        LinkedHashSet<TypeMirror> result = new LinkedHashSet<TypeMirror>();
        toAdd.add(typeMirror);
        for (int i = 0; i < toAdd.size(); ++i) {
            TypeMirror type = (TypeMirror)toAdd.get(i);
            if (!result.add(type)) continue;
            toAdd.addAll(types.directSupertypes(type));
        }
        return result;
    }

    public boolean supertypeHasGeneric(Types types, TypeMirror typeMirror, TypeMirror implementsMirror) {
        TypeMirror superTypeMirror = this.getFlattenedSupertype(types, typeMirror, implementsMirror);
        if (superTypeMirror == null) {
            return false;
        }
        return superTypeMirror.toString().contains("<");
    }

    public TypeMirror getFlattenedSupertype(Types types, TypeMirror typeMirror, TypeMirror implementsMirror) {
        String implementsMirrorWithoutGeneric = this.removeGenericsFromClassName(implementsMirror.toString());
        Set<TypeMirror> implementedSuperTypes = this.getFlattenedSupertypeHierarchy(types, typeMirror);
        for (TypeMirror typeMirrorSuperType : implementedSuperTypes) {
            String tn1WithoutGenric = this.removeGenericsFromClassName(typeMirrorSuperType.toString());
            if (!implementsMirrorWithoutGeneric.equals(tn1WithoutGenric)) continue;
            return typeMirrorSuperType;
        }
        return null;
    }

    public void createErrorMessage(String errorMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(errorMessage);
        pw.close();
        this.messager.printMessage(Diagnostic.Kind.ERROR, sw.toString());
    }

    public String createFullClassName(String packageName, String className) {
        return packageName.replace(".", "_") + "_" + className;
    }

    public void createNoteMessage(String noteMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(noteMessage);
        pw.close();
        this.messager.printMessage(Diagnostic.Kind.NOTE, sw.toString());
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public ProcessorUtils build() {
            return new ProcessorUtils(this);
        }
    }
}

