/*
 * Decompiled with CFR 0.152.
 */
package com.github.nalukit.nalu.processor;

import com.github.nalukit.nalu.plugin.gwt.client.annotation.Selector;
import com.github.nalukit.nalu.plugin.gwt.client.selector.AbstractSelectorProvider;
import com.github.nalukit.nalu.plugin.gwt.client.selector.IsSelectorProvider;
import com.github.nalukit.nalu.plugin.gwt.client.selector.SelectorCommand;
import com.github.nalukit.nalu.plugin.gwt.client.selector.SelectorProvider;
import com.github.nalukit.nalu.processor.ProcessorException;
import com.github.nalukit.nalu.processor.ProcessorUtils;
import com.github.nalukit.nalu.processor.model.intern.ClassNameModel;
import com.google.auto.service.AutoService;
import com.google.common.base.Stopwatch;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@AutoService(value={Processor.class})
public class NaluPluginGwtProcessor
extends AbstractProcessor {
    private static final String IMPL_NAME = "SelectorProviderImpl";
    private ProcessorUtils processorUtils;
    private Stopwatch stopwatch;
    private Map<Element, List<SelectorMetaModel>> models;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.of(Selector.class.getCanonicalName()).collect(Collectors.toSet());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.stopwatch = Stopwatch.createStarted();
        this.setUp();
        this.processorUtils.createNoteMessage("Nalu-Plugin-GWT-Processor started ...");
        this.processorUtils.createNoteMessage("Nalu-Plugin-GWT-Processor version >>2.2.1<<");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                this.processorUtils.createNoteMessage("Nalu-Plugin-GWT-Processor finished ... processing takes: " + this.stopwatch.stop().toString());
            } else if (annotations.size() > 0) {
                for (TypeElement typeElement : annotations) {
                    for (Element element : roundEnv.getElementsAnnotatedWith(Selector.class)) {
                        this.validate(element);
                        Element enclosingElement = element.getEnclosingElement();
                        Selector selectorAnnotation = element.getAnnotation(Selector.class);
                        this.models.computeIfAbsent(enclosingElement, s -> new ArrayList()).add(new SelectorMetaModel(selectorAnnotation.value(), enclosingElement.toString(), element));
                    }
                }
                for (Element element : this.models.keySet()) {
                    this.generate(element, this.models.get(element));
                }
            }
        }
        catch (ProcessorException e) {
            this.processorUtils.createErrorMessage(e.getMessage());
            return true;
        }
        return true;
    }

    private void validate(Element element) throws ProcessorException {
        if (!ElementKind.METHOD.equals((Object)element.getKind())) {
            throw new ProcessorException("Nalu-Processor: @Selector can only be used with a method");
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getParameters().size() != 1) {
            throw new ProcessorException("Nalu-Processor: @Selector can only be used with a method that has one parameter");
        }
        String parameterClass = executableElement.getParameters().get(0).asType().toString();
        if (!IsWidget.class.getCanonicalName().equals(parameterClass) && !Widget.class.getCanonicalName().equals(parameterClass)) {
            throw new ProcessorException("Nalu-Processor: @Selector can only be used with a method that has one parameter and the parameter type is com.google.gwt.user.client.ui.IsWidget or com.google.gwt.user.client.ui.Widget");
        }
    }

    private void generate(Element enclosingElement, List<SelectorMetaModel> models) throws ProcessorException {
        ClassNameModel enclosingClassNameModel = new ClassNameModel(enclosingElement.toString());
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)(enclosingElement.getSimpleName() + IMPL_NAME)).superclass((TypeName)ClassName.get(AbstractSelectorProvider.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(IsSelectorProvider.class), (TypeName[])new TypeName[]{enclosingClassNameModel.getTypeName()}));
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super()", new Object[0]).build();
        typeSpec.addMethod(constructor);
        MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder((String)"initialize").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)enclosingClassNameModel.getPackage(), (String)enclosingClassNameModel.getSimpleName(), (String[])new String[0]), (String)"component", (Modifier[])new Modifier[0]).build()).addAnnotation(Override.class);
        models.forEach(model -> initializeMethod.addStatement("$T.get().getSelectorCommands().put($S, $L)", new Object[]{ClassName.get(SelectorProvider.class), ((SelectorMetaModel)model).selector, TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface(SelectorCommand.class).addMethod(MethodSpec.methodBuilder((String)"append").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(IsWidget.class), (String)"widget", (Modifier[])new Modifier[0]).build()).addStatement("component.$L(widget.asWidget())", new Object[]{model.getSelectorElement().getSimpleName().toString()}).build()).build()}).build());
        typeSpec.addMethod(initializeMethod.build());
        MethodSpec.Builder removeMethod = MethodSpec.methodBuilder((String)"removeSelectors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class);
        models.forEach(model -> removeMethod.addStatement("$T.get().getSelectorCommands().remove($S)", new Object[]{ClassName.get(SelectorProvider.class), model.getSelector()}).build());
        typeSpec.addMethod(removeMethod.build());
        JavaFile javaFile = JavaFile.builder((String)enclosingClassNameModel.getPackage(), (TypeSpec)typeSpec.build()).build();
        try {
            javaFile.writeTo(this.processingEnv.getFiler());
        }
        catch (IOException e) {
            throw new ProcessorException("Unable to write generated file: >>" + enclosingElement.getSimpleName() + IMPL_NAME + "<< -> exception: " + e.getMessage());
        }
    }

    private void setUp() {
        this.models = new HashMap<Element, List<SelectorMetaModel>>();
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnv).build();
    }

    static class SelectorMetaModel {
        private String selector;
        private String enclosingElement;
        private Element selectorElement;

        public SelectorMetaModel(String selector, String enclosingElement, Element selectorElement) {
            this.selector = selector;
            this.enclosingElement = enclosingElement;
            this.selectorElement = selectorElement;
        }

        public String getSelector() {
            return this.selector;
        }

        public String getEnclosingElement() {
            return this.enclosingElement;
        }

        public Element getSelectorElement() {
            return this.selectorElement;
        }

        public ClassNameModel getEnclosingElementModel() {
            return new ClassNameModel(this.enclosingElement);
        }
    }
}

