/*
 * Decompiled with CFR 0.152.
 */
package com.github.nalukit.nalu.processor;

import com.github.nalukit.nalu.processor.model.intern.ClassNameModel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ProcessorUtils {
    private ProcessingEnvironment processingEnvironment;
    private Types types;
    private Messager messager;
    private Filer filer;
    private Elements elements;

    private ProcessorUtils(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.types = this.processingEnvironment.getTypeUtils();
        this.messager = this.processingEnvironment.getMessager();
        this.filer = this.processingEnvironment.getFiler();
        this.elements = this.processingEnvironment.getElementUtils();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean implementsInterface(ProcessingEnvironment processingEnvironment, TypeElement typeElement, TypeMirror implementedInterface) {
        return processingEnvironment.getTypeUtils().isAssignable(typeElement.asType(), implementedInterface);
    }

    public String getPackageAsString(Element type) {
        return this.getPackage(type).getQualifiedName().toString();
    }

    public PackageElement getPackage(Element type) {
        while (type.getKind() != ElementKind.PACKAGE) {
            type = type.getEnclosingElement();
        }
        return (PackageElement)type;
    }

    public Elements getElements() {
        return this.elements;
    }

    public boolean extendsClassOrInterface(Types types, TypeMirror typeMirror, TypeMirror toImplement) {
        String clearedToImplement = this.removeGenericsFromClassName(toImplement.toString());
        Set<TypeMirror> setOfSuperType = this.getFlattenedSupertypeHierarchy(types, typeMirror);
        for (TypeMirror mirror : setOfSuperType) {
            if (!clearedToImplement.equals(this.removeGenericsFromClassName(mirror.toString()))) continue;
            return true;
        }
        return false;
    }

    private String removeGenericsFromClassName(String className) {
        if (className.contains("<")) {
            className = className.substring(0, className.indexOf("<"));
        }
        return className;
    }

    public Set<TypeMirror> getFlattenedSupertypeHierarchy(Types types, TypeMirror typeMirror) {
        ArrayList<? extends TypeMirror> toAdd = new ArrayList<TypeMirror>();
        LinkedHashSet<TypeMirror> result = new LinkedHashSet<TypeMirror>();
        toAdd.add(typeMirror);
        for (int i = 0; i < toAdd.size(); ++i) {
            TypeMirror type = (TypeMirror)toAdd.get(i);
            if (!result.add(type)) continue;
            toAdd.addAll(types.directSupertypes(type));
        }
        return result;
    }

    public boolean supertypeHasGeneric(Types types, TypeMirror typeMirror, TypeMirror implementsMirror) {
        TypeMirror superTypeMirror = this.getFlattenedSupertype(types, typeMirror, implementsMirror);
        if (superTypeMirror == null) {
            return false;
        }
        return superTypeMirror.toString().contains("<");
    }

    public TypeMirror getFlattenedSupertype(Types types, TypeMirror typeMirror, TypeMirror implementsMirror) {
        String implementsMirrorWihoutGeneric = this.removeGenericsFromClassName(implementsMirror.toString());
        Set<TypeMirror> implementedSuperTypes = this.getFlattenedSupertypeHierarchy(types, typeMirror);
        for (TypeMirror typeMirrorSuperType : implementedSuperTypes) {
            String tn1WithoutGenric = this.removeGenericsFromClassName(typeMirrorSuperType.toString());
            if (!implementsMirrorWihoutGeneric.equals(tn1WithoutGenric)) continue;
            return typeMirrorSuperType;
        }
        return null;
    }

    public void createErrorMessage(String errorMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(errorMessage);
        pw.close();
        this.messager.printMessage(Diagnostic.Kind.ERROR, sw.toString());
    }

    public String createFullClassName(String packageName, String className) {
        return packageName.replace(".", "_") + "_" + className;
    }

    public void createNoteMessage(String noteMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(noteMessage);
        pw.close();
        this.messager.printMessage(Diagnostic.Kind.NOTE, sw.toString());
    }

    public void createWarningMessage(String warningMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(warningMessage);
        pw.close();
        this.messager.printMessage(Diagnostic.Kind.WARNING, sw.toString());
    }

    public <A extends Annotation> List<Element> getMethodFromTypeElementAnnotatedWith(ProcessingEnvironment processingEnvironment, TypeElement element, Class<A> annotation) {
        List<Element> annotatedMethods = processingEnvironment.getElementUtils().getAllMembers(element).stream().filter(methodElement -> methodElement.getAnnotation(annotation) != null).collect(Collectors.toList());
        return annotatedMethods;
    }

    public String createInternalEventName(ExecutableElement executableElement) {
        String internalEventname = executableElement.getSimpleName().toString();
        for (VariableElement variableElement : executableElement.getParameters()) {
            internalEventname = internalEventname + "_pPp_";
            internalEventname = internalEventname + variableElement.asType().toString().replace(".", "_");
        }
        return internalEventname;
    }

    public boolean doesExist(ClassNameModel typeElementClassName) {
        return this.processingEnvironment.getElementUtils().getTypeElement(typeElementClassName.getClassName()) != null;
    }

    public String createHistoryMetaDataClassName(String historyConverterClassName) {
        return this.setFirstCharacterToUpperCase(this.createHistoryMetaDataVariableName(historyConverterClassName)) + "_" + "MetaData";
    }

    public String setFirstCharacterToUpperCase(String className) {
        return className.substring(0, 1).toUpperCase() + className.substring(1);
    }

    public String createHistoryMetaDataVariableName(String historyConverterClassName) {
        return this.createFullClassName(historyConverterClassName);
    }

    public String createFullClassName(String className) {
        return className.replace(".", "_");
    }

    public String createEventHandlingMethodName(String eventName) {
        return "on" + eventName.substring(0, 1).toUpperCase() + eventName.substring(1);
    }

    public String createEventNameFromHandlingMethod(String event) {
        return event.substring(2, 3).toLowerCase() + event.substring(3);
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public ProcessorUtils build() {
            return new ProcessorUtils(this);
        }
    }
}

