/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.transform.common;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;

public abstract class AbstractWrappedMapBasedTransformer<B, C extends Map<I, E>, E, I> {
    private final Function<B, B> cloneFunction;
    private final Function<B, C> mapReadFunction;
    private final BiFunction<B, C, B> mapWriteBiFunction;
    private final Collector<Map.Entry<I, E>, ?, C> mapCollector;

    public AbstractWrappedMapBasedTransformer(@NotNull Supplier<B> instanceSupplier, @NotNull Function<B, C> mapReadFunction, @NotNull BiFunction<B, C, B> mapWriteBiFunction, @NotNull Collector<Map.Entry<I, E>, ?, C> mapCollector) {
        this((B request) -> AbstractWrappedMapBasedTransformer.cloneWrapper(request, instanceSupplier), mapReadFunction, mapWriteBiFunction, mapCollector);
    }

    public AbstractWrappedMapBasedTransformer(@NotNull Function<B, B> cloneFunction, @NotNull Function<B, C> mapReadFunction, @NotNull BiFunction<B, C, B> mapWriteBiFunction, @NotNull Collector<Map.Entry<I, E>, ?, C> mapCollector) {
        this.cloneFunction = cloneFunction;
        this.mapReadFunction = mapReadFunction;
        this.mapWriteBiFunction = mapWriteBiFunction;
        this.mapCollector = mapCollector;
    }

    @NotNull
    private static <B> B cloneWrapper(@NotNull B batch, @NotNull Supplier<B> instanceSupplier) {
        B target = instanceSupplier.get();
        BeanUtils.copyProperties(batch, target);
        return target;
    }

    @NotNull
    protected final Map<I, B> splitToMap(@NotNull B batch) {
        return ((Map)this.mapReadFunction.apply(batch)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.mapWriteBiFunction.apply(this.cloneFunction.apply(batch), (Map)Stream.of(entry).collect(this.mapCollector))));
    }

    @Nullable
    protected final B mergeToBatch(@NotNull Map<I, B> map) {
        return map.values().stream().findFirst().map(request -> this.mapWriteBiFunction.apply(this.cloneFunction.apply(request), (Map)map.values().stream().map(this.mapReadFunction).map(Map::entrySet).flatMap(Collection::stream).collect(this.mapCollector))).orElse(null);
    }
}

