/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.transform.common;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;

public class AbstractWrappedCollectionBasedTransformer<B, C extends Collection<E>, E, I> {
    private final Function<B, B> cloneFunction;
    private final Function<B, C> collectionReadFunction;
    private final BiFunction<B, C, B> collectionWriteBiFunction;
    private final Collector<E, ?, C> collectionCollector;
    private final Function<E, I> idFunction;

    public AbstractWrappedCollectionBasedTransformer(@NotNull Supplier<B> instanceSupplier, @NotNull Function<B, C> collectionReadFunction, @NotNull BiFunction<B, C, B> collectionWriteBiFunction, @NotNull Collector<E, ?, C> collectionCollector, @NotNull Function<E, I> idFunction) {
        this((B response) -> AbstractWrappedCollectionBasedTransformer.cloneWrapper(response, instanceSupplier), collectionReadFunction, collectionWriteBiFunction, collectionCollector, idFunction);
    }

    public AbstractWrappedCollectionBasedTransformer(@NotNull Function<B, B> cloneFunction, @NotNull Function<B, C> collectionReadFunction, @NotNull BiFunction<B, C, B> collectionWriteBiFunction, @NotNull Collector<E, ?, C> collectionCollector, @NotNull Function<E, I> idFunction) {
        this.cloneFunction = cloneFunction;
        this.collectionReadFunction = collectionReadFunction;
        this.collectionWriteBiFunction = collectionWriteBiFunction;
        this.collectionCollector = collectionCollector;
        this.idFunction = idFunction;
    }

    @NotNull
    private static <B> B cloneWrapper(@NotNull B batch, @NotNull Supplier<B> instanceSupplier) {
        B target = instanceSupplier.get();
        BeanUtils.copyProperties(batch, target);
        return target;
    }

    @NotNull
    protected final Map<I, B> splitToMap(@NotNull B batch) {
        return ((Collection)this.collectionReadFunction.apply(batch)).stream().collect(Collectors.toMap(this.idFunction, entity -> this.collectionWriteBiFunction.apply(this.cloneFunction.apply(batch), (Collection)Stream.of(entity).collect(this.collectionCollector))));
    }

    @Nullable
    protected final B mergeToBatch(@NotNull Map<I, B> map) {
        return map.values().stream().findFirst().map(entity -> this.collectionWriteBiFunction.apply(this.cloneFunction.apply(entity), (Collection)map.values().stream().map(this.collectionReadFunction).flatMap(Collection::stream).collect(this.collectionCollector))).orElse(null);
    }
}

