/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.transform.common;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractMapBasedTransformer<C extends Map<I, P>, P, I> {
    private final Collector<Map.Entry<I, P>, ?, C> mergeMapCollector;
    private final Function<Map.Entry<I, P>, I> splitKeyTransformer;
    private final Function<Map.Entry<I, P>, P> splitValueTransformer;
    private final boolean nullIfEmpty;

    public AbstractMapBasedTransformer(@NotNull Collector<Map.Entry<I, P>, ?, C> mergeMapCollector) {
        this(mergeMapCollector, Map.Entry::getKey, Map.Entry::getValue, false);
    }

    public AbstractMapBasedTransformer(@NotNull Collector<Map.Entry<I, P>, ?, C> mergeMapCollector, @NotNull Function<Map.Entry<I, P>, I> splitKeyTransformer, @NotNull Function<Map.Entry<I, P>, P> splitValueTransformer, boolean nullIfEmpty) {
        this.mergeMapCollector = mergeMapCollector;
        this.splitKeyTransformer = splitKeyTransformer;
        this.splitValueTransformer = splitValueTransformer;
        this.nullIfEmpty = nullIfEmpty;
    }

    @NotNull
    protected final Map<I, P> splitToMap(@NotNull C batch) {
        return batch.entrySet().stream().collect(Collectors.toMap(this.splitKeyTransformer, this.splitValueTransformer));
    }

    @Nullable
    protected final C mergeToBatch(@NotNull Map<I, P> map) {
        if (map.isEmpty() && this.nullIfEmpty) {
            return null;
        }
        return (C)((Map)map.entrySet().stream().collect(this.mergeMapCollector));
    }
}

