/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.transform.common;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractCollectionBasedTransformer<C extends Collection<P>, P, I> {
    private final Collector<P, ?, C> collectionCollector;
    private final Function<P, I> idFunction;
    private final boolean nullIfEmpty;

    public AbstractCollectionBasedTransformer(@NotNull Collector<P, ?, C> collectionCollector, @NotNull Function<P, I> idFunction) {
        this(collectionCollector, idFunction, false);
    }

    public AbstractCollectionBasedTransformer(@NotNull Collector<P, ?, C> collectionCollector, @NotNull Function<P, I> idFunction, boolean nullIfEmpty) {
        this.collectionCollector = collectionCollector;
        this.idFunction = idFunction;
        this.nullIfEmpty = nullIfEmpty;
    }

    @NotNull
    protected final Map<I, P> splitToMap(@NotNull C batch) {
        return batch.stream().collect(Collectors.toMap(this.idFunction, Function.identity()));
    }

    @Nullable
    protected final C mergeToBatch(@NotNull Map<I, P> map) {
        if (map.isEmpty() && this.nullIfEmpty) {
            return null;
        }
        return (C)((Collection)map.values().stream().collect(this.collectionCollector));
    }
}

