/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.transform;

import com.github.nagyesta.cacheonly.entity.CacheKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public interface PartialCacheSupport<PR, PS, C, I> {
    @NotNull
    public String cacheName();

    @NotNull
    public Class<PS> getEntityClass();

    @Nullable
    public CacheKey<C, I> toCacheKey(@NotNull PR var1);

    @NotNull
    public CacheManager getCacheManager();

    @NotNull
    default public Cache obtainCache() {
        return this.getCacheManager().getCache(this.cacheName());
    }

    default public void putToCache(@NotNull CacheKey<C, I> key, @NotNull PS entity) {
        this.obtainCache().put(key.getKey(), entity);
    }

    @Nullable
    default public PS getFromCache(@NotNull CacheKey<C, I> key) {
        return (PS)this.obtainCache().get(key.getKey(), this.getEntityClass());
    }
}

