/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.entity;

import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public final class CacheKey<C, I> {
    private final C key;
    private final I id;

    public CacheKey(@NotNull C key, @NotNull I id) {
        this.key = key;
        this.id = id;
    }

    @NotNull
    public C getKey() {
        return this.key;
    }

    @NotNull
    public I getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheKey)) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return this.key.equals(cacheKey.key) && this.id.equals(cacheKey.id);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.id);
    }

    public String toString() {
        return new StringJoiner(", ", CacheKey.class.getSimpleName() + "[", "]").add("key=" + this.key).add("id=" + this.id).toString();
    }
}

