/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.core;

import com.github.nagyesta.cacheonly.core.AbstractCacheServiceTemplate;
import com.github.nagyesta.cacheonly.core.CacheRefreshStrategy;
import com.github.nagyesta.cacheonly.core.exception.CacheMissException;
import com.github.nagyesta.cacheonly.raw.BatchServiceCaller;
import com.github.nagyesta.cacheonly.raw.exception.BatchServiceException;
import com.github.nagyesta.cacheonly.transform.BatchRequestTransformer;
import com.github.nagyesta.cacheonly.transform.BatchResponseTransformer;
import com.github.nagyesta.cacheonly.transform.PartialCacheSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultCacheServiceTemplate<BR, BS, PR, PS, C, I>
extends AbstractCacheServiceTemplate<BatchServiceCaller<BR, BS>, PartialCacheSupport<PR, PS, C, I>, BR, BS, PR, PS, C, I> {
    public DefaultCacheServiceTemplate(@NotNull PartialCacheSupport<PR, PS, C, I> partialCacheSupport, @NotNull BatchRequestTransformer<BR, PR, I> batchRequestTransformer, @NotNull BatchResponseTransformer<BS, PS, I> batchResponseTransformer, @NotNull BatchServiceCaller<BR, BS> batchServiceCaller) {
        super(partialCacheSupport, batchRequestTransformer, batchResponseTransformer, batchServiceCaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Map<I, PS> fetchAllFromCache(@NotNull CacheRefreshStrategy strategy, @NotNull Map<I, PR> requestMap) throws CacheMissException {
        long start = System.currentTimeMillis();
        HashMap result = new HashMap();
        try {
            for (Map.Entry entry : requestMap.entrySet()) {
                this.fetchOneFromCache(strategy, entry.getValue()).ifPresent(v -> result.put(entry.getKey(), v));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logger().debug("Fetch all from cache completed under {} ms.", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Map<I, PS> callOriginWithPartitions(@NotNull List<Map<I, PR>> requestPartitions) throws BatchServiceException {
        long start = System.currentTimeMillis();
        HashMap response = new HashMap();
        try {
            for (Map<I, PR> partitionedMap : requestPartitions) {
                response.putAll(this.fetchSinglePartitionFromOrigin(partitionedMap, this.batchServiceCaller().refreshStrategy()));
            }
            HashMap hashMap = response;
            return hashMap;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logger().debug("Fetch all from origin completed under {} ms.", (Object)(end - start));
        }
    }
}

