/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.Assert;

public enum CacheRefreshStrategy {
    CACHE_ONLY{

        @Override
        @NotNull
        public <I> Set<I> selectItemsForFetch(@NotNull Set<I> allRequestIds, @NotNull Set<I> idsFoundInCache, int maxPartitionSize) {
            this.assertInputIsValid(allRequestIds, idsFoundInCache, maxPartitionSize);
            return Collections.emptySet();
        }
    }
    ,
    OPTIMISTIC,
    OPPORTUNISTIC{

        @Override
        @NotNull
        public <I> Set<I> selectItemsForFetch(@NotNull Set<I> allRequestIds, @NotNull Set<I> idsFoundInCache, int maxPartitionSize) {
            this.assertInputIsValid(allRequestIds, idsFoundInCache, maxPartitionSize);
            HashSet result = new HashSet(SetUtils.difference(allRequestIds, idsFoundInCache));
            if (result.size() > 0) {
                int mustBeInLastPartition = result.size() % maxPartitionSize;
                ArrayList<I> fetchExtra = new ArrayList<I>(idsFoundInCache);
                Collections.shuffle(fetchExtra);
                fetchExtra.stream().limit(maxPartitionSize - mustBeInLastPartition).forEach(result::add);
            }
            return result;
        }
    }
    ,
    PESSIMISTIC{

        @Override
        public boolean shouldFailOnMiss() {
            return true;
        }

        @Override
        @NotNull
        public <I> Set<I> selectItemsForFetch(@NotNull Set<I> allRequestIds, @NotNull Set<I> idsFoundInCache, int maxPartitionSize) {
            this.assertInputIsValid(allRequestIds, idsFoundInCache, maxPartitionSize);
            Object result = SetUtils.difference(allRequestIds, idsFoundInCache);
            if (!result.isEmpty()) {
                result = allRequestIds;
            }
            return result;
        }
    }
    ,
    NEVER_CACHE{

        @Override
        public boolean allowsCacheGet() {
            return false;
        }

        @Override
        public boolean allowsCachePut() {
            return false;
        }
    };


    public boolean allowsCacheGet() {
        return true;
    }

    public boolean shouldFailOnMiss() {
        return false;
    }

    public boolean allowsCachePut() {
        return true;
    }

    @NotNull
    public <I> Set<I> selectItemsForFetch(@NotNull Set<I> allRequestIds, @NotNull Set<I> idsFoundInCache, int maxPartitionSize) {
        this.assertInputIsValid(allRequestIds, idsFoundInCache, maxPartitionSize);
        return SetUtils.difference(allRequestIds, idsFoundInCache);
    }

    protected <I> void assertInputIsValid(@NotNull Set<I> allRequestIds, @NotNull Set<I> idsFoundInCache, int maxPartitionSize) {
        Assert.notNull(allRequestIds, (String)"AllRequestIds cannot be null.");
        Assert.noNullElements((Object[])allRequestIds.toArray(), (String)"AllRequestIds cannot contain null.");
        Assert.notNull(idsFoundInCache, (String)"IdsFoundInCache cannot be null.");
        Assert.noNullElements((Object[])idsFoundInCache.toArray(), (String)"IdsFoundInCache cannot contain null.");
        Assert.isTrue((maxPartitionSize > 0 ? 1 : 0) != 0, (String)"MaxPartitionSize must be at least 1.");
        SetUtils.SetView foundInCacheButNotWanted = SetUtils.difference(idsFoundInCache, allRequestIds);
        Assert.isTrue((boolean)foundInCacheButNotWanted.isEmpty(), (String)("Unexpected Id(s) found in cache: " + (Set)foundInCacheButNotWanted));
    }
}

