/*
 * Decompiled with CFR 0.152.
 */
package com.github.nagyesta.cacheonly.core;

import com.github.nagyesta.cacheonly.core.CacheRefreshStrategy;
import com.github.nagyesta.cacheonly.core.CachingServiceTemplate;
import com.github.nagyesta.cacheonly.core.exception.CacheMissException;
import com.github.nagyesta.cacheonly.core.metrics.BatchServiceCallMetricCollector;
import com.github.nagyesta.cacheonly.core.metrics.NoOpBatchServiceCallMetricCollector;
import com.github.nagyesta.cacheonly.entity.CacheKey;
import com.github.nagyesta.cacheonly.raw.BatchServiceCaller;
import com.github.nagyesta.cacheonly.raw.exception.BatchServiceException;
import com.github.nagyesta.cacheonly.transform.BatchRequestTransformer;
import com.github.nagyesta.cacheonly.transform.BatchResponseTransformer;
import com.github.nagyesta.cacheonly.transform.PartialCacheSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractCacheServiceTemplate<SC extends BatchServiceCaller<BR, BS>, CS extends PartialCacheSupport<PR, PS, C, I>, BR, BS, PR, PS, C, I>
implements CachingServiceTemplate<BR, BS> {
    private final Logger logger;
    private final CS partialCacheSupport;
    private final BatchRequestTransformer<BR, PR, I> batchRequestTransformer;
    private final BatchResponseTransformer<BS, PS, I> batchResponseTransformer;
    private final SC batchServiceCaller;
    private BatchServiceCallMetricCollector metricsCollector = new NoOpBatchServiceCallMetricCollector();

    public AbstractCacheServiceTemplate(@NotNull CS partialCacheSupport, @NotNull BatchRequestTransformer<BR, PR, I> batchRequestTransformer, @NotNull BatchResponseTransformer<BS, PS, I> batchResponseTransformer, @NotNull SC batchServiceCaller) {
        this.partialCacheSupport = partialCacheSupport;
        this.batchRequestTransformer = batchRequestTransformer;
        this.batchResponseTransformer = batchResponseTransformer;
        this.batchServiceCaller = batchServiceCaller;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BS callCacheableBatchService(@NotNull BR request) throws BatchServiceException {
        long start = System.currentTimeMillis();
        Map<I, PR> requestMap = this.batchRequestTransformer.splitToPartialRequest(request);
        try {
            Map<Object, Object> fromCache;
            this.logger.info("Processing batch of {} partial requests.", (Object)requestMap.size());
            this.logger.trace("Processing batch of partial requests with ids: {}", requestMap.keySet());
            try {
                fromCache = this.attemptFetchingFromCache(requestMap, this.batchServiceCaller.refreshStrategy());
                requestMap = this.selectRemainingKeysToFetchFromOrigin(requestMap, fromCache);
            }
            catch (CacheMissException e) {
                fromCache = new HashMap();
                this.metricsCollector.cacheMiss(requestMap.size());
                this.logger.info("Cache miss found for requestClass: {}, refresh strategy disallows further tries. Cause: {}", (Object)request.getClass().getName(), (Object)e.getMessage());
            }
            fromCache.putAll(this.fetchAllFromOriginService(requestMap));
            BS BS = this.batchResponseTransformer.mergeToBatchResponse(fromCache);
            return BS;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logger().debug("Total execution completed under {} ms.", (Object)(end - start));
        }
    }

    @Override
    @Nullable
    public BS callBatchServiceAndPutAllToCache(@NotNull BR request) throws BatchServiceException {
        Map<I, PR> requestMap = this.batchRequestTransformer.splitToPartialRequest(request);
        Map<I, PS> response = this.fetchAllFromOriginService(requestMap);
        return this.batchResponseTransformer.mergeToBatchResponse(response);
    }

    @NotNull
    protected Map<I, PS> fetchAllFromOriginService(@NotNull Map<I, PR> requestMap) throws BatchServiceException {
        Map<Object, Object> response;
        if (requestMap.isEmpty()) {
            response = Collections.emptyMap();
        } else {
            List<Map<I, PR>> partitions = this.partitionOriginRequests(requestMap);
            this.metricsCollector.partitionsCreated(partitions.size());
            try {
                response = this.callOriginWithPartitions(partitions);
                this.metricsCollector.partitionsSucceeded(partitions.size());
            }
            catch (BatchServiceException e) {
                this.metricsCollector.partitionsFailed(partitions.size());
                throw e;
            }
        }
        return response;
    }

    @NotNull
    protected abstract Map<I, PS> callOriginWithPartitions(@NotNull List<Map<I, PR>> var1) throws BatchServiceException;

    protected void populateCacheWithResponse(@NotNull CacheRefreshStrategy strategy, @NotNull Map<I, PR> request, @NotNull Map<I, PS> response) {
        if (strategy.allowsCachePut()) {
            this.logger.trace("Responses passed for cache PUT with ids: {}", response.keySet());
            this.logger.trace("Requests passed for cache PUT with ids: {}", request.keySet());
            Assert.isTrue((boolean)request.keySet().containsAll(response.keySet()), (String)"Not all requests ids are found in the request.");
            response.forEach((id, entity) -> Optional.ofNullable(this.partialCacheSupport.toCacheKey(request.get(id))).ifPresent(cacheKey -> this.partialCacheSupport.putToCache(cacheKey, (Object)entity)));
            this.metricsCollector.cachePut(response.size());
            this.logger.debug("Cache PUT completed for {} items.", (Object)response.size());
        } else {
            this.logger.debug("Cache PUT not allowed by {} strategy, skipping.", (Object)strategy.name());
        }
    }

    @NotNull
    private List<Map<I, PR>> partitionOriginRequests(@NotNull Map<I, PR> requestMap) {
        ArrayList<I> keyList = new ArrayList<I>(requestMap.keySet());
        List partitions = ListUtils.partition(keyList, (int)this.batchServiceCaller.maxPartitionSize());
        this.logger.debug("Created {} partitions.", (Object)partitions.size());
        return partitions.stream().map(p -> p.stream().collect(Collectors.toMap(Function.identity(), requestMap::get))).collect(Collectors.toList());
    }

    @NotNull
    private Map<I, PR> selectRemainingKeysToFetchFromOrigin(@NotNull Map<I, PR> requestMap, Map<I, PS> fromCache) {
        Set<I> toBeFetched = this.batchServiceCaller.refreshStrategy().selectItemsForFetch(requestMap.keySet(), fromCache.keySet(), this.batchServiceCaller.maxPartitionSize());
        this.logger.trace("Fetch will be performed for ids: {}", toBeFetched);
        this.logger.debug("Fetch will be performed for {} items.", (Object)toBeFetched.size());
        return toBeFetched.stream().collect(Collectors.toMap(Function.identity(), requestMap::get));
    }

    @NotNull
    private Map<I, PS> attemptFetchingFromCache(@NotNull Map<I, PR> requestMap, @NotNull CacheRefreshStrategy strategy) throws CacheMissException {
        HashMap<I, PS> result = new HashMap<I, PS>();
        if (strategy.allowsCacheGet()) {
            this.metricsCollector.cacheGet(requestMap.size());
            this.logger.debug("Attempting cache GET for {} items.", (Object)requestMap.size());
            result.putAll(this.fetchAllFromCache(strategy, requestMap));
            this.metricsCollector.cacheHit(result.size());
            this.metricsCollector.cacheMiss(requestMap.size() - result.size());
            this.logger.info("Cache HIT for {} items.", (Object)result.size());
            this.logger.trace("Cache HIT for ids: {}", result.keySet());
        } else {
            this.logger.debug("Cache GET is not allowed by {} strategy, skipping.", (Object)strategy.name());
        }
        return result;
    }

    @NotNull
    protected abstract Map<I, PS> fetchAllFromCache(@NotNull CacheRefreshStrategy var1, @NotNull Map<I, PR> var2) throws CacheMissException;

    @NotNull
    protected Optional<PS> fetchOneFromCache(@NotNull CacheRefreshStrategy strategy, @NotNull PR request) throws CacheMissException {
        Optional key = Optional.ofNullable(this.partialCacheSupport.toCacheKey(request));
        Optional<Object> fromCache = key.map(arg_0 -> this.partialCacheSupport.getFromCache(arg_0));
        if (!fromCache.isPresent()) {
            if (strategy.shouldFailOnMiss()) {
                throw new CacheMissException("Item with id not found in cache: " + key.map(CacheKey::getId).orElse(null));
            }
            key.ifPresent(k -> this.logger.trace("Cache miss observed for key: {}", k));
        }
        return fromCache;
    }

    @NotNull
    protected Map<I, PS> fetchSinglePartitionFromOrigin(@NotNull Map<I, PR> requestMap, @NotNull CacheRefreshStrategy strategy) throws BatchServiceException {
        HashMap<I, PS> response = new HashMap<I, PS>(this.doFetchFromOrigin(requestMap));
        this.logger().trace("Responses fetched for ids: {}", response.keySet());
        this.logger().debug("Responses fetched for {} items.", (Object)response.size());
        this.populateCacheWithResponse(strategy, requestMap, response);
        return response;
    }

    @NotNull
    private Map<I, PS> doFetchFromOrigin(@NotNull Map<I, PR> requestMap) throws BatchServiceException {
        Optional<BR> batchRequest = Optional.ofNullable(this.batchRequestTransformer().mergeToBatchRequest(requestMap));
        Map response = Collections.emptyMap();
        if (batchRequest.isPresent()) {
            Optional listResponse = Optional.ofNullable(this.batchServiceCaller().callBatchService(batchRequest.get()));
            response = listResponse.map(this.batchResponseTransformer()::splitToPartialResponse).orElse(Collections.emptyMap());
        }
        return response;
    }

    protected final CS partialCacheSupport() {
        return this.partialCacheSupport;
    }

    protected final SC batchServiceCaller() {
        return this.batchServiceCaller;
    }

    protected final BatchRequestTransformer<BR, PR, I> batchRequestTransformer() {
        return this.batchRequestTransformer;
    }

    protected final BatchResponseTransformer<BS, PS, I> batchResponseTransformer() {
        return this.batchResponseTransformer;
    }

    protected final Logger logger() {
        return this.logger;
    }

    public final void setMetricsCollector(BatchServiceCallMetricCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }
}

