package com.github.nagyesta.cacheonly.transform;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * Defines behavior of response transformation between partial and batch responses.
 *
 * @param <B> The type of the batch response.
 * @param <P> The type of the partial response.
 * @param <I> The type of the Id that can identify a partial response and pair it
 *            with a partial request of a batch request we try to respond to.
 */
public interface BatchResponseTransformer<B, P, I> {

    /**
     * Splits the batch response into the small partial responses used for caching.
     *
     * @param batchResponse The batch response containing all information received
     *                      in response to the batch request.
     * @return A map of partial response using the request Id to identify them.
     */
    @NotNull
    Map<I, P> splitToPartialResponse(@NotNull B batchResponse);

    /**
     * Merges the partial response map (supposedly generated by a previous split or
     * obtained from the cache) into a batch response.
     *
     * @param entityMap The map containing the partial responses.
     * @return The merged batch response.
     */
    @Nullable
    B mergeToBatchResponse(@NotNull Map<I, P> entityMap);

}
