package com.github.nagyesta.cacheonly.transform;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * Defines behavior of request transformation between partial and batch requests.
 *
 * @param <B> The type of the batch request.
 * @param <P> The type of the partial request.
 * @param <I> The type of the Id that can identify a partial request in the scope
 *            of a batch.
 */
public interface BatchRequestTransformer<B, P, I> {

    /**
     * Splits the batch request into the small partial requests used for caching.
     *
     * @param batchRequest The batch request containing all information needed for
     *                     the partial requests.
     * @return A map of partial requests using the request Id to identify them.
     */
    @NotNull
    Map<I, P> splitToPartialRequest(@NotNull B batchRequest);

    /**
     * Merges the partial request map (supposedly generated by a previous split)
     * into a batch request.
     *
     * @param requestMap The map containing the partial requests.
     * @return The merged batch request.
     */
    @Nullable
    B mergeToBatchRequest(@NotNull Map<I, P> requestMap);

}
