/*
 * Decompiled with CFR 0.152.
 */
package com.github.mwarc.embeddedmemcached;

import com.github.mwarc.embeddedmemcached.MemcachedServer;
import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheImpl;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.ConcurrentLinkedHashMap;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JMemcachedServer
implements MemcachedServer {
    private static Logger logger = LoggerFactory.getLogger(JMemcachedServer.class);
    public static final long DEFAULT_STARTUP_TIMEOUT = 10000L;
    private static final int DEFAULT_STORAGE_CAPACITY = 1000;
    private static final long DEFAULT_STORAGE_MEMORY_CAPACITY = 10000L;
    private MemCacheDaemon<LocalCacheElement> memcacheDaemon;

    @Override
    public void start(final String host, final int port) {
        logger.debug("Starting memcache...");
        final CountDownLatch startupLatch = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ConcurrentLinkedHashMap storage = ConcurrentLinkedHashMap.create((ConcurrentLinkedHashMap.EvictionPolicy)ConcurrentLinkedHashMap.EvictionPolicy.FIFO, (int)1000, (long)10000L);
                JMemcachedServer.this.memcacheDaemon = new MemCacheDaemon();
                JMemcachedServer.this.memcacheDaemon.setCache((Cache)new CacheImpl((CacheStorage)storage));
                JMemcachedServer.this.memcacheDaemon.setAddr(new InetSocketAddress(host, port));
                JMemcachedServer.this.memcacheDaemon.start();
                startupLatch.countDown();
            }
        });
        try {
            if (!startupLatch.await(10000L, TimeUnit.MILLISECONDS)) {
                logger.error("Memcache daemon did not start after {}ms. Consider increasing the timeout", (Object)TimeUnit.MILLISECONDS);
                throw new AssertionError((Object)"Memcache daemon did not start within timeout");
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted waiting for Memcache daemon to start:", (Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void clean() {
        if (this.memcacheDaemon != null) {
            logger.debug("Cleaning memcache...");
            this.memcacheDaemon.getCache().flush_all();
        }
    }
}

