/*
 * Decompiled with CFR 0.152.
 */
package com.github.mwarc.embeddedmemcached;

import com.github.mwarc.embeddedmemcached.EmbeddedMemcached;
import com.github.mwarc.embeddedmemcached.JMemcachedServer;
import com.github.mwarc.embeddedmemcached.MemcachedServer;
import com.google.common.base.Preconditions;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class AbstractEmbeddedMemcachedTestExecutionListener
extends AbstractTestExecutionListener {
    private static boolean initialized;
    private MemcachedServer server = new JMemcachedServer();

    protected void startServer(TestContext testContext) {
        EmbeddedMemcached embeddedMemcached = (EmbeddedMemcached)Preconditions.checkNotNull((Object)AnnotationUtils.findAnnotation((Class)testContext.getTestClass(), EmbeddedMemcached.class), (Object)("EmbeddedMemcachedDIIntegrationTestExecutionListener must be used with @EmbeddedMemcached on " + testContext.getTestClass()));
        String host = (String)Preconditions.checkNotNull((Object)embeddedMemcached.host(), (Object)"@EmbeddedMemcached host must not be null");
        int port = (Integer)Preconditions.checkNotNull((Object)embeddedMemcached.port(), (Object)"@EmbeddedMemcached port must not be null");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"@EmbeddedMemcached port must not be > 0");
        if (!initialized) {
            this.server.start(host, port);
            initialized = true;
        }
    }

    protected void cleanServer() {
        this.server.clean();
    }
}

