/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.logging.ErrorsLoggingList;
import com.github.mkopylec.errorest.response.Error;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.util.Assert;

@JacksonXmlRootElement(localName="body")
public class Errors {
    public static final String EMPTY_ERRORS_ID = "N/A";
    protected final String id;
    @JacksonXmlProperty(localName="error")
    @JacksonXmlElementWrapper(localName="errors")
    protected final List<Error> errors;

    @JsonCreator
    public Errors(@JsonProperty(value="id") @JacksonXmlProperty(localName="id") String id, @JsonProperty(value="errors") @JacksonXmlProperty(localName="Jackson bug workaround") List<Error> errors) {
        Assert.hasText((String)id, (String)"Empty errors ID");
        this.id = id;
        this.errors = errors == null ? new ErrorsLoggingList() : new ErrorsLoggingList((Collection<? extends Error>)errors);
    }

    public String getId() {
        return this.id;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean containsErrorCode(String code) {
        return this.errors.stream().anyMatch(error -> error.hasCode(code));
    }

    public boolean containsErrorDescriptions() {
        return this.errors.stream().anyMatch(Error::hasDescription);
    }

    public boolean containsErrorDescription(String description) {
        return this.errors.stream().anyMatch(error -> error.hasDescription(description));
    }

    @JsonIgnore
    public boolean isEmpty() {
        return EMPTY_ERRORS_ID.equals(this.id) && !this.hasErrors();
    }

    public void formatErrors(ErrorestProperties.ResponseBodyFormat bodyFormat) {
        this.errors.forEach(error -> error.format(bodyFormat));
    }

    public static Errors emptyErrors() {
        return new Errors(EMPTY_ERRORS_ID, Collections.emptyList());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Errors rhs = (Errors)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).append(this.errors, rhs.errors).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append(this.errors).toHashCode();
    }
}

