/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Error {
    public static final String DESCRIPTION_NOT_AVAILABLE = "N/A";
    protected final String code;
    protected String description;

    @JsonCreator
    public Error(@JsonProperty(value="code") @JacksonXmlProperty(localName="code") String code, @JsonProperty(value="description") @JacksonXmlProperty(localName="description") String description) {
        this.code = code;
        this.description = StringUtils.isNotBlank((CharSequence)description) ? description : DESCRIPTION_NOT_AVAILABLE;
    }

    public String getCode() {
        return this.code;
    }

    public boolean hasCode(String code) {
        return this.code.equals(code);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return !this.description.equals(DESCRIPTION_NOT_AVAILABLE);
    }

    public boolean hasDescription(String description) {
        return this.description.equals(description);
    }

    public void format(ErrorestProperties.ResponseBodyFormat bodyFormat) {
        switch (bodyFormat) {
            case FULL: {
                return;
            }
            case WITHOUT_DESCRIPTIONS: {
                this.description = DESCRIPTION_NOT_AVAILABLE;
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported response body format: " + (Object)((Object)bodyFormat));
    }

    public String toString() {
        return this.code + ": " + this.description;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Error rhs = (Error)obj;
        return new EqualsBuilder().append((Object)this.code, (Object)rhs.code).append((Object)this.description, (Object)rhs.description).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.code).append((Object)this.description).toHashCode();
    }
}

