/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.logging;

import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.logging.LoggingLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionLogger {
    private static final Logger log = LoggerFactory.getLogger(ExceptionLogger.class);

    public void log(ErrorData errorData) {
        this.log(LoggingLevel.TRACE, errorData, () -> log.trace(this.createLogMessage(errorData), errorData.getThrowable()));
        this.log(LoggingLevel.DEBUG, errorData, () -> log.debug(this.createLogMessage(errorData), errorData.getThrowable()));
        this.log(LoggingLevel.INFO, errorData, () -> log.info(this.createLogMessage(errorData), errorData.getThrowable()));
        this.log(LoggingLevel.WARN, errorData, () -> log.warn(this.createLogMessage(errorData), errorData.getThrowable()));
        this.log(LoggingLevel.ERROR, errorData, () -> log.error(this.createLogMessage(errorData), errorData.getThrowable()));
    }

    protected void log(LoggingLevel loggingLevel, ErrorData errorData, Runnable logger) {
        if (!errorData.hasLoggingLevel(loggingLevel)) {
            return;
        }
        logger.run();
    }

    protected String createLogMessage(ErrorData errorData) {
        return "ID: " + errorData.getId() + " | " + errorData.getRequestMethod() + " " + errorData.getRequestUri() + " " + errorData.getResponseStatus() + " | " + errorData.getErrors();
    }
}

