/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.validation;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.response.Error;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public abstract class BeanValidationErrorDataProvider<T extends Throwable>
extends ErrorDataProvider<T> {
    public BeanValidationErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    protected ErrorData.ErrorDataBuilder buildErrorData(BindingResult result) {
        ErrorestProperties.BeanValidationError validationError = this.errorestProperties.getBeanValidationError();
        ErrorData.ErrorDataBuilder builder = ErrorData.ErrorDataBuilder.newErrorData().withLoggingLevel(validationError.getLoggingLevel()).withResponseStatus(HttpStatus.UNPROCESSABLE_ENTITY);
        result.getAllErrors().forEach(objectError -> {
            Error error = this.createError((ObjectError)objectError);
            builder.addError(error);
        });
        return builder;
    }

    protected Error createError(ObjectError error) {
        return new Error(error.getDefaultMessage(), "Invalid '" + this.getField(error) + "' value: " + this.getRejectedValue(error));
    }

    protected String getField(ObjectError error) {
        return error instanceof FieldError ? ((FieldError)error).getField() : error.getObjectName();
    }

    protected Object getRejectedValue(ObjectError error) {
        return error instanceof FieldError ? ((FieldError)error).getRejectedValue() : "[N/A]";
    }
}

