/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.security;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.ControllerErrorHandler;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.handling.utils.HttpUtils;
import com.github.mkopylec.errorest.logging.LoggingLevel;
import com.github.mkopylec.errorest.response.Error;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;

public abstract class SecurityErrorDataProvider<T extends Throwable>
extends ErrorDataProvider<T> {
    public static final String SECURITY_ERROR_CODE = "SECURITY_ERROR";

    public SecurityErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(T ex, HttpServletRequest request) {
        if (request.getAttribute(ControllerErrorHandler.CONTROLLER_ERROR_HANDLING_ATTRIBUTE) != null) {
            request.removeAttribute(ControllerErrorHandler.CONTROLLER_ERROR_HANDLING_ATTRIBUTE);
            throw (RuntimeException)ex;
        }
        return this.buildErrorData(ex, HttpUtils.getHeadersAsText(request)).withRequestMethod(request.getMethod()).withRequestUri(request.getRequestURI()).build();
    }

    @Override
    public ErrorData getErrorData(T ex, HttpStatus defaultResponseStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        String requestMethod = this.getRequestMethod(requestAttributes);
        String requestUri = this.getRequestUri(errorAttributes, requestAttributes);
        String requestHeaders = this.getRequestHeaders(requestAttributes);
        return this.buildErrorData(ex, requestHeaders).withRequestMethod(requestMethod).withRequestUri(requestUri).build();
    }

    protected ErrorData.ErrorDataBuilder buildErrorData(T ex, String requestHeaders) {
        LoggingLevel loggingLevel = this.errorestProperties.getHttpClientError().getLoggingLevel();
        String description = this.getErrorDescription(requestHeaders);
        return ErrorData.ErrorDataBuilder.newErrorData().withLoggingLevel(loggingLevel).withResponseStatus(this.getResponseHttpStatus()).withThrowable((Throwable)ex).addError(new Error(SECURITY_ERROR_CODE, description));
    }

    protected abstract HttpStatus getResponseHttpStatus();

    protected abstract String getErrorDescription(String var1);
}

