/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.github.mkopylec.errorest.response.Errors;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class ErrorsHttpResponseSetter {
    private static final Logger log = LoggerFactory.getLogger(ErrorsHttpResponseSetter.class);
    protected ObjectMapper jsonMapper = Jackson2ObjectMapperBuilder.json().build();
    protected XmlMapper xmlMapper = (XmlMapper)Jackson2ObjectMapperBuilder.xml().build();

    public void setErrorsResponse(Errors errors, HttpStatus responseHttpStatus, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(responseHttpStatus.value());
        HttpResponseData responseData = this.getResponseData(errors, request);
        if (responseData != null) {
            response.addHeader("Content-Type", responseData.getContentType());
            response.getWriter().write(responseData.getBody());
        }
    }

    public void setJsonMapper(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public void setXmlMapper(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    protected HttpResponseData getResponseData(Errors errors, HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        try {
            if (this.hasAcceptedType(MediaType.APPLICATION_JSON, acceptHeader)) {
                String body = this.jsonMapper.writeValueAsString((Object)errors);
                return new HttpResponseData("application/json", body);
            }
            if (this.hasAcceptedType(MediaType.APPLICATION_XML, acceptHeader)) {
                String body = this.xmlMapper.writeValueAsString((Object)errors);
                return new HttpResponseData("application/xml", body);
            }
            throw new IOException("Incompatible HTTP request Accept header: " + acceptHeader);
        }
        catch (IOException e) {
            log.warn("Cannot convert {} to HTTP response body: {}", (Object)errors, (Object)e.getMessage());
            return null;
        }
    }

    protected boolean hasAcceptedType(MediaType accept, String acceptHeader) {
        return StringUtils.isNotBlank((CharSequence)acceptHeader) && MediaType.parseMediaType((String)acceptHeader).includes(accept);
    }

    public static class HttpResponseData {
        protected final String contentType;
        protected final String body;

        protected HttpResponseData(String contentType, String body) {
            this.contentType = contentType;
            this.body = body;
        }

        protected String getContentType() {
            return this.contentType;
        }

        protected String getBody() {
            return this.body;
        }
    }
}

