/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.security;

import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProviderContext;
import com.github.mkopylec.errorest.handling.errordata.security.ErrorsHttpResponseSetter;
import com.github.mkopylec.errorest.response.Errors;
import com.github.mkopylec.errorest.response.ErrorsFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class ErrorestAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    protected final ErrorDataProviderContext providerContext;
    protected final ErrorsFactory errorsFactory;
    protected final ErrorsHttpResponseSetter responseBodySetter;

    public ErrorestAuthenticationEntryPoint(ErrorDataProviderContext providerContext, ErrorsFactory errorsFactory, ErrorsHttpResponseSetter responseBodySetter) {
        this.providerContext = providerContext;
        this.errorsFactory = errorsFactory;
        this.responseBodySetter = responseBodySetter;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) throws IOException, ServletException {
        ErrorData errorData = this.getErrorData(ex, request);
        Errors errors = this.errorsFactory.logAndCreateErrors(errorData);
        this.responseBodySetter.setErrorsResponse(errors, errorData.getResponseStatus(), request, response);
    }

    protected ErrorData getErrorData(AuthenticationException ex, HttpServletRequest request) {
        ErrorDataProvider provider = this.providerContext.getErrorDataProvider(ex);
        return provider.getErrorData(ex, request);
    }
}

