/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.rest;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.exceptions.ExternalHttpRequestException;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.logging.LoggingLevel;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;

public class ExternalHttpRequestErrorDataProvider
extends ErrorDataProvider<ExternalHttpRequestException> {
    public ExternalHttpRequestErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(ExternalHttpRequestException ex, HttpServletRequest request) {
        return this.buildErrorData(ex, ex.getStatusCode()).withRequestMethod(request.getMethod()).withRequestUri(request.getRequestURI()).build();
    }

    @Override
    public ErrorData getErrorData(ExternalHttpRequestException ex, HttpStatus defaultResponseStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        String requestMethod = this.getRequestMethod(requestAttributes);
        String requestUri = this.getRequestUri(errorAttributes, requestAttributes);
        return this.buildErrorData(ex, ex.getStatusCode()).withRequestMethod(requestMethod).withRequestUri(requestUri).build();
    }

    protected ErrorData.ErrorDataBuilder buildErrorData(ExternalHttpRequestException ex, HttpStatus responseHttpStatus) {
        ErrorData.ErrorDataBuilder builder = ErrorData.ErrorDataBuilder.newErrorData().withLoggingLevel(this.getLoggingLevel(responseHttpStatus)).withResponseStatus(responseHttpStatus).withThrowable((Throwable)((Object)ex));
        ex.getResponseBodyAsErrors().getErrors().forEach(builder::addError);
        return builder;
    }

    protected LoggingLevel getLoggingLevel(HttpStatus responseHttpStatus) {
        return responseHttpStatus.is4xxClientError() ? this.errorestProperties.getHttpClientError().getLoggingLevel() : LoggingLevel.ERROR;
    }
}

