/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.rest;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.exceptions.ApplicationException;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;

public class ApplicationErrorDataProvider
extends ErrorDataProvider<ApplicationException> {
    public ApplicationErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(ApplicationException ex, HttpServletRequest request) {
        return this.buildErrorData(ex).withRequestMethod(request.getMethod()).withRequestUri(request.getRequestURI()).build();
    }

    @Override
    public ErrorData getErrorData(ApplicationException ex, HttpStatus defaultResponseStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        String requestMethod = this.getRequestMethod(requestAttributes);
        String requestUri = this.getRequestUri(errorAttributes, requestAttributes);
        return this.buildErrorData(ex).withRequestMethod(requestMethod).withRequestUri(requestUri).build();
    }

    protected ErrorData.ErrorDataBuilder buildErrorData(ApplicationException ex) {
        ErrorData.ErrorDataBuilder builder = ErrorData.ErrorDataBuilder.newErrorData().withLoggingLevel(ex.getLoggingLevel()).withResponseStatus(ex.getResponseHttpStatus()).withThrowable(ex);
        ex.getErrors().forEach(builder::addError);
        return builder;
    }
}

