/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.http;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.http.HttpClientErrorDataProvider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.context.request.RequestAttributes;

public class RequestMethodNotSupportedErrorDataProvider
extends HttpClientErrorDataProvider<HttpRequestMethodNotSupportedException> {
    public RequestMethodNotSupportedErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(HttpRequestMethodNotSupportedException ex, HttpServletRequest request) {
        return this.getErrorData(ex, request, HttpStatus.METHOD_NOT_ALLOWED);
    }

    @Override
    public ErrorData getErrorData(HttpRequestMethodNotSupportedException ex, HttpStatus responseHttpStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        return super.getErrorData(ex, HttpStatus.METHOD_NOT_ALLOWED, errorAttributes, requestAttributes);
    }

    @Override
    protected String getErrorDescription(HttpRequestMethodNotSupportedException ex) {
        return HttpStatus.METHOD_NOT_ALLOWED.getReasonPhrase() + ", supported methods are " + StringUtils.join((Object[])ex.getSupportedMethods(), (String)", ");
    }
}

