/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.http;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.http.HttpClientErrorDataProvider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.context.request.RequestAttributes;

public class MessageNotReadableErrorDataProvider
extends HttpClientErrorDataProvider<HttpMessageNotReadableException> {
    public MessageNotReadableErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(HttpMessageNotReadableException ex, HttpServletRequest request) {
        return this.getErrorData(ex, request, HttpStatus.BAD_REQUEST);
    }

    @Override
    public ErrorData getErrorData(HttpMessageNotReadableException ex, HttpStatus responseHttpStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        return super.getErrorData(ex, HttpStatus.BAD_REQUEST, errorAttributes, requestAttributes);
    }

    @Override
    protected String getErrorDescription(HttpMessageNotReadableException ex) {
        return HttpStatus.BAD_REQUEST.getReasonPhrase() + ", " + StringUtils.uncapitalize((String)ex.getMessage());
    }
}

