/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.http;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.http.HttpClientErrorDataProvider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.context.request.RequestAttributes;

public class MediaTypeNotSupportedErrorDataProvider
extends HttpClientErrorDataProvider<HttpMediaTypeNotSupportedException> {
    public MediaTypeNotSupportedErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(HttpMediaTypeNotSupportedException ex, HttpServletRequest request) {
        return this.getErrorData(ex, request, HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @Override
    public ErrorData getErrorData(HttpMediaTypeNotSupportedException ex, HttpStatus responseHttpStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        return super.getErrorData(ex, HttpStatus.UNSUPPORTED_MEDIA_TYPE, errorAttributes, requestAttributes);
    }

    @Override
    protected String getErrorDescription(HttpMediaTypeNotSupportedException ex) {
        return HttpStatus.UNSUPPORTED_MEDIA_TYPE.getReasonPhrase() + ": " + ex.getContentType() + ", supported media types are " + StringUtils.join((Iterable)ex.getSupportedMediaTypes(), (String)", ");
    }
}

