/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.http;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.http.HttpClientErrorDataProvider;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.context.request.RequestAttributes;

public class MediaTypeNotAcceptableErrorDataProvider
extends HttpClientErrorDataProvider<HttpMediaTypeNotAcceptableException> {
    public MediaTypeNotAcceptableErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(HttpMediaTypeNotAcceptableException ex, HttpServletRequest request) {
        return this.getErrorData(ex, request, HttpStatus.NOT_ACCEPTABLE);
    }

    @Override
    public ErrorData getErrorData(HttpMediaTypeNotAcceptableException ex, HttpStatus responseHttpStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        return super.getErrorData(ex, HttpStatus.NOT_ACCEPTABLE, errorAttributes, requestAttributes);
    }

    @Override
    protected String getErrorDescription(HttpMediaTypeNotAcceptableException ex) {
        return HttpStatus.NOT_ACCEPTABLE.getReasonPhrase() + ", acceptable media types are " + StringUtils.join((Iterable)ex.getSupportedMediaTypes(), (String)", ");
    }
}

