/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.http;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.logging.LoggingLevel;
import com.github.mkopylec.errorest.response.Error;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;

public abstract class HttpClientErrorDataProvider<T extends Throwable>
extends ErrorDataProvider<T> {
    public static final String HTTP_CLIENT_ERROR_CODE = "HTTP_CLIENT_ERROR";

    public HttpClientErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(T ex, HttpStatus responseHttpStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        String requestMethod = this.getRequestMethod(requestAttributes);
        String requestUri = this.getRequestUri(errorAttributes, requestAttributes);
        return this.buildErrorData(ex, responseHttpStatus).withRequestMethod(requestMethod).withRequestUri(requestUri).build();
    }

    protected ErrorData getErrorData(T ex, HttpServletRequest request, HttpStatus responseHttpStatus) {
        return this.buildErrorData(ex, responseHttpStatus).withRequestMethod(request.getMethod()).withRequestUri(request.getRequestURI()).build();
    }

    protected ErrorData.ErrorDataBuilder buildErrorData(T ex, HttpStatus responseHttpStatus) {
        LoggingLevel loggingLevel = this.errorestProperties.getHttpClientError().getLoggingLevel();
        return ErrorData.ErrorDataBuilder.newErrorData().withLoggingLevel(loggingLevel).withResponseStatus(responseHttpStatus).withThrowable((Throwable)ex).addError(new Error(HTTP_CLIENT_ERROR_CODE, this.getErrorDescription(ex)));
    }

    protected abstract String getErrorDescription(T var1);
}

