/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata.generic;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.logging.LoggingLevel;
import com.github.mkopylec.errorest.response.Error;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;

public class ThrowableErrorDataProvider
extends ErrorDataProvider<Throwable> {
    public static final String UNEXPECTED_ERROR_CODE = "UNEXPECTED_ERROR";

    public ThrowableErrorDataProvider(ErrorestProperties errorestProperties) {
        super(errorestProperties);
    }

    @Override
    public ErrorData getErrorData(Throwable ex, HttpServletRequest request) {
        return this.buildErrorData(ex, HttpStatus.INTERNAL_SERVER_ERROR).withRequestMethod(request.getMethod()).withRequestUri(request.getRequestURI()).build();
    }

    @Override
    public ErrorData getErrorData(Throwable ex, HttpStatus defaultResponseStatus, ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        String requestMethod = this.getRequestMethod(requestAttributes);
        String requestUri = this.getRequestUri(errorAttributes, requestAttributes);
        return this.buildErrorData(ex, defaultResponseStatus).withRequestMethod(requestMethod).withRequestUri(requestUri).withResponseStatus(defaultResponseStatus).build();
    }

    protected ErrorData.ErrorDataBuilder buildErrorData(Throwable ex, HttpStatus responseHttpStatus) {
        return ErrorData.ErrorDataBuilder.newErrorData().withLoggingLevel(this.getLoggingLevel(responseHttpStatus)).withResponseStatus(responseHttpStatus).withThrowable(ex).addError(new Error(this.getErrorCode(responseHttpStatus), this.getErrorDescription(ex, responseHttpStatus)));
    }

    protected LoggingLevel getLoggingLevel(HttpStatus responseHttpStatus) {
        return responseHttpStatus.is4xxClientError() ? this.errorestProperties.getHttpClientError().getLoggingLevel() : LoggingLevel.ERROR;
    }

    protected String getErrorCode(HttpStatus responseHttpStatus) {
        return responseHttpStatus.is4xxClientError() ? "HTTP_CLIENT_ERROR" : UNEXPECTED_ERROR_CODE;
    }

    protected String getErrorDescription(Throwable ex, HttpStatus responseHttpStatus) {
        return ex == null ? responseHttpStatus.getReasonPhrase() : ex.getMessage();
    }
}

