/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata;

import com.github.mkopylec.errorest.configuration.ErrorestProperties;
import com.github.mkopylec.errorest.handling.RequestAttributeSettingFilter;
import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;

public abstract class ErrorDataProvider<T extends Throwable> {
    public static final String REQUEST_URI_ERROR_ATTRIBUTE = "path";
    public static final String NOT_AVAILABLE_DATA = "[N/A]";
    protected final ErrorestProperties errorestProperties;

    protected ErrorDataProvider(ErrorestProperties errorestProperties) {
        this.errorestProperties = errorestProperties;
    }

    public abstract ErrorData getErrorData(T var1, HttpServletRequest var2);

    public abstract ErrorData getErrorData(T var1, HttpStatus var2, ErrorAttributes var3, RequestAttributes var4);

    protected String getRequestUri(ErrorAttributes errorAttributes, RequestAttributes requestAttributes) {
        return errorAttributes.getErrorAttributes(requestAttributes, false).getOrDefault(REQUEST_URI_ERROR_ATTRIBUTE, NOT_AVAILABLE_DATA).toString();
    }

    protected String getRequestMethod(RequestAttributes requestAttributes) {
        return this.getAttribute(RequestAttributeSettingFilter.REQUEST_METHOD_ERROR_ATTRIBUTE, requestAttributes);
    }

    protected String getRequestHeaders(RequestAttributes requestAttributes) {
        return this.getAttribute(RequestAttributeSettingFilter.REQUEST_HEADERS_ERROR_ATTRIBUTE, requestAttributes);
    }

    protected String getAttribute(String name, RequestAttributes requestAttributes) {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)requestAttributes.getAttribute(name, 0)), (CharSequence)NOT_AVAILABLE_DATA);
    }
}

