/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling.errordata;

import com.github.mkopylec.errorest.logging.ErrorsLoggingList;
import com.github.mkopylec.errorest.logging.LoggingLevel;
import com.github.mkopylec.errorest.response.Error;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;

public class ErrorData {
    public static final int ERRORS_ID_LENGTH = 10;
    protected final String id;
    protected final LoggingLevel loggingLevel;
    protected final String requestMethod;
    protected final String requestUri;
    protected final HttpStatus responseStatus;
    protected final List<Error> errors;
    protected final Throwable throwable;

    protected ErrorData(String id, LoggingLevel loggingLevel, String requestMethod, String requestUri, HttpStatus responseStatus, List<Error> errors, Throwable throwable) {
        this.id = id;
        this.loggingLevel = loggingLevel;
        this.requestMethod = requestMethod;
        this.requestUri = requestUri;
        this.responseStatus = responseStatus;
        this.errors = errors;
        this.throwable = throwable;
    }

    public String getId() {
        return this.id;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public boolean hasLoggingLevel(LoggingLevel level) {
        return this.loggingLevel == level;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public HttpStatus getResponseStatus() {
        return this.responseStatus;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public static final class ErrorDataBuilder {
        protected String id;
        protected LoggingLevel loggingLevel;
        protected String requestMethod;
        protected String requestUri;
        protected HttpStatus responseStatus;
        protected List<Error> errors = new ErrorsLoggingList();
        protected Throwable throwable;

        private ErrorDataBuilder() {
            this.id = RandomStringUtils.randomAlphanumeric((int)10).toLowerCase();
        }

        public static ErrorDataBuilder newErrorData() {
            return new ErrorDataBuilder();
        }

        public ErrorDataBuilder withLoggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public ErrorDataBuilder withRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public ErrorDataBuilder withRequestUri(String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        public ErrorDataBuilder withResponseStatus(HttpStatus responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public ErrorDataBuilder addError(Error error) {
            this.errors.add(error);
            return this;
        }

        public ErrorDataBuilder withThrowable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public ErrorData build() {
            return new ErrorData(this.id, this.loggingLevel, this.requestMethod, this.requestUri, this.responseStatus, this.errors, this.throwable);
        }
    }
}

