/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.errorest.handling;

import com.github.mkopylec.errorest.handling.errordata.ErrorData;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProvider;
import com.github.mkopylec.errorest.handling.errordata.ErrorDataProviderContext;
import com.github.mkopylec.errorest.response.Errors;
import com.github.mkopylec.errorest.response.ErrorsFactory;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
public class ServletFilterErrorHandler
extends AbstractErrorController {
    protected final ErrorAttributes errorAttributes;
    protected final ErrorProperties errorProperties;
    protected final ErrorsFactory errorsFactory;
    protected final ErrorDataProviderContext providerContext;

    public ServletFilterErrorHandler(ErrorAttributes errorAttributes, ServerProperties serverProperties, ErrorsFactory errorsFactory, ErrorDataProviderContext providerContext) {
        super(errorAttributes, Collections.emptyList());
        this.errorAttributes = errorAttributes;
        this.errorProperties = serverProperties.getError();
        this.errorsFactory = errorsFactory;
        this.providerContext = providerContext;
    }

    @RequestMapping(value={"${server.error.path:${error.path:/error}}"})
    public ResponseEntity<Errors> error(HttpServletRequest request) {
        ErrorData errorData = this.getErrorData(request);
        Errors errors = this.errorsFactory.logAndCreateErrors(errorData);
        return ResponseEntity.status((HttpStatus)errorData.getResponseStatus()).body((Object)errors);
    }

    public String getErrorPath() {
        return this.errorProperties.getPath();
    }

    protected ErrorData getErrorData(HttpServletRequest request) {
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request);
        Throwable ex = this.errorAttributes.getError((RequestAttributes)requestAttributes);
        ErrorDataProvider provider = this.providerContext.getErrorDataProvider(ex);
        return provider.getErrorData(ex, this.getStatus(request), this.errorAttributes, (RequestAttributes)requestAttributes);
    }
}

